package com.payu.india.Tasks;

import android.util.Log;

import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import com.payu.india.Payu.V2ApiHelper;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

public class UpdateDeviceIdTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private final String TAG = getClass().getSimpleName();

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PostData postData = new PostData();
        PayuResponse payuResponse = new PayuResponse();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_APIV2_URL);
                    break;
                default:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).
                    setURL(url + PayuConstants.DEVICE_ID_API_ENDPOINT).setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader(PayuConstants.PAYU_FETCH_DEVICE_ID)).
                    setRequestType(PayuConstants.REQUEST_APPLICATION_JSON).build();

            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, true);
                JSONObject response = new JSONObject(responseStringBuffer.toString());

                payuResponse.setRawResponse(response);
                if (response.has(PayuConstants.STATUS) && response.optInt(PayuConstants.STATUS) == 1) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                } else {
                    postData.setResult(PayuErrors.ERROR_INVALID_GAID);
                    postData.setStatus(PayuConstants.ERROR);
                }
            }
        } catch (MalformedURLException e) {
            Log.d(TAG, " MalformedURLException" + e.getMessage());
            postData.setCode(PayuErrors.MALFORMED_URL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (ProtocolException e) {
            Log.d(TAG, " ProtocolException " + e.getMessage());
            postData.setCode(PayuErrors.PROTOCOL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, " IOException " + e.getMessage());
            postData.setCode(PayuErrors.IO_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (JSONException e) {
            Log.d(TAG, " JSONException " + e.getMessage());
            postData.setCode(PayuErrors.JSON_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        }

        payuResponse.setResponseStatus(postData);
        return payuResponse;

    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
    }
}
