package com.payu.india.Tasks;

import static com.payu.india.Payu.PayuConstants.IFSC_CODE_URL;
import static com.payu.india.Payu.PayuConstants.PAYU_IFSC_CODE_PARAM;

import android.os.AsyncTask;
import android.util.Log;

import com.payu.india.Interfaces.FetchIFSCDetailsListener;
import com.payu.india.Model.IFSCCodeDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import com.payu.india.Payu.V2ApiHelper;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

/**
 * Async task which takes care of Getting IFSC code details
 * Activity which calls {@link FetchIFSCDetailsTask} should implement {@link FetchIFSCDetailsListener}
 */
public class FetchIFSCDetailsTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    FetchIFSCDetailsListener mIfscDetailsListener;

    public FetchIFSCDetailsTask(FetchIFSCDetailsListener ifscDetailsListener) {
        mIfscDetailsListener = ifscDetailsListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();

        try {
            // get the request first
            PayuConfig payuConfig = params[0];
            URL url;
            if (payuConfig.getEnvironment() == PayuConstants.STAGING_ENV) {
                url = new URL(PayuConstants.TEST_APIV2_URL);
            } else {
                url = new URL(PayuConstants.APIV2_URL);
            }

            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.GET).setRequestType(PayuConstants.REQUEST_APPLICATION_JSON).
                    setURL(url + IFSC_CODE_URL + PAYU_IFSC_CODE_PARAM + payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader(PayuConstants.PAYU_FETCH_IFSC_DETAILS)).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConnForGetRequest(request);
            if (null != conn) {
                StringBuilder responseStringBuilder = PayuUtils.getStringBuilder(conn, true);

                JSONObject response = new JSONObject(responseStringBuilder.toString());
                payuResponse.setRawResponse(response);
                if (conn.getResponseCode() == 200 && response.optJSONObject(PayuConstants.PAYU_RESULT_RESPONSE) != null) {

                    JSONObject resultObject = response.getJSONObject(PayuConstants.PAYU_RESULT_RESPONSE).optJSONObject(PayuConstants.PAYU_RESULT);
                    if (resultObject != null) {
                        IFSCCodeDetails ifscCodeDetails = new IFSCCodeDetails();
                        ifscCodeDetails.setBank(resultObject.optString(PayuConstants.IFSC_BANK));
                        ifscCodeDetails.setCity(resultObject.optString(PayuConstants.IFSC_CITY));
                        ifscCodeDetails.setIfsc(resultObject.optString(PayuConstants.IFSC_KEY));
                        ifscCodeDetails.setMicr(resultObject.optString(PayuConstants.IFSC_MICR));
                        ifscCodeDetails.setState(resultObject.optString(PayuConstants.IFSC_STATE));
                        ifscCodeDetails.setBranch(resultObject.optString(PayuConstants.IFSC_BRANCH));
                        ifscCodeDetails.setOffice(resultObject.optString(PayuConstants.IFSC_OFFICE));
                        ifscCodeDetails.setAddress(resultObject.optString(PayuConstants.IFSC_ADDRESS));
                        ifscCodeDetails.setContact(resultObject.optString(PayuConstants.IFSC_CONTACT));
                        ifscCodeDetails.setDistrict(resultObject.optString(PayuConstants.IFSC_DISTRICT));
                        payuResponse.setIfscCodeDetails(ifscCodeDetails);
                        postData.setCode(PayuErrors.NO_ERROR);
                        postData.setStatus(PayuConstants.SUCCESS);
                    } else {
                        postData.setCode(PayuErrors.ERROR_CODE_INVALID_IFSC_DETAILS);
                        postData.setResult(PayuErrors.ERROR_INVALID_IFSC_DETAILS);
                        postData.setStatus(PayuConstants.ERROR);
                    }
                } else if (conn.getResponseCode() == 429) {
                    postData.setCode(conn.getResponseCode());
                    postData.setResult(PayuErrors.ERROR_TOO_MANY_IFSC_REQUESTS);
                    postData.setStatus(PayuConstants.ERROR);
                } else if (conn.getResponseCode() == 400) {
                    postData.setCode(conn.getResponseCode());
                    postData.setResult(PayuErrors.ERROR_IFSC_NOT_FOUND);
                    postData.setStatus(PayuConstants.ERROR);
                } else {
                    postData.setCode(conn.getResponseCode());
                    postData.setResult(response.optString(PayuConstants.DESCRIPTION));
                    postData.setStatus(PayuConstants.ERROR);
                }

                payuResponse.setResponseStatus(postData);
            }
        } catch (IOException | JSONException e) {
            Log.d(getClass().getSimpleName(), "Exception " + e.getMessage());
        }
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mIfscDetailsListener.onIFSCDetailsReceived(payuResponse);
    }
}