package com.payu.india.Tasks;


import com.payu.india.Interfaces.DeleteSavedOptionsListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONObject;

import java.io.InputStream;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

public class DeleteSavedOptionsTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {


    DeleteSavedOptionsListener deleteSavedOptionsListener;
    PayuConfig mPayuConfig;
    PayuResponse mPayuResponse;

    public DeleteSavedOptionsTask(DeleteSavedOptionsListener deleteSavedOptionsListener){
        this.deleteSavedOptionsListener = deleteSavedOptionsListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {

            URL url = null;
            // get the payuConfig first
            //TODO put check if payuConfig has data
            PayuConfig payuConfig = params[0];
            // set the environment

            //TODO make it function call
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_APIV2_URL);
                    break;
                default:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
            }

            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).
                    setURL(url + PayuConstants.PAYU_DELETE_API_ENDPOINT).setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader(PayuConstants.PAYU_DELETE_SAVED_OPTIONS)).
                    setRequestType(PayuConstants.REQUEST_APPLICATION_JSON).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                StringBuilder responseStringBuffer = PayuUtils.getStringBuilder(conn, false);

                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                return payuResponse;
            }

        } catch (Exception e){
         return null;
        }

        return null;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        deleteSavedOptionsListener.onDeleteSavedOptionResponse(payuResponse);
    }
}
