package com.payu.india.Tasks;

import android.util.Log;

import com.payu.india.Interfaces.CheckBalanceListener;
import com.payu.india.Model.Olw.OlwSDKInfo;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.SodexoCardInfo;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Iterator;

import javax.net.ssl.HttpsURLConnection;

public class CheckBalanceTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private final String TAG = getClass().getSimpleName();

    CheckBalanceListener checkBalanceListener;

    public CheckBalanceTask(CheckBalanceListener checkBalanceListener) {
        this.checkBalanceListener = checkBalanceListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }

            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData(), payuConfig.getFetchSodexoBalanceTimeout());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(jsonResponse);
                SodexoCardInfo sodexoCardInfo = new SodexoCardInfo();
                if (jsonResponse.has(PayuConstants.STATUS) && jsonResponse.optInt(PayuConstants.STATUS) == 1) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                    sodexoCardInfo.setCardNo(jsonResponse.optString(PayuConstants.CARDNO));
                    sodexoCardInfo.setCardBalance(jsonResponse.optString(PayuConstants.CARD_BALANCE));
                    sodexoCardInfo.setCardName(jsonResponse.optString(PayuConstants.CARDNAME));
                    sodexoCardInfo.setMsg(jsonResponse.optString(PayuConstants.MSG));
                    JSONObject olwJson = jsonResponse.optJSONObject(PayuConstants.OLW);
                    if (olwJson != null) {
                        Iterator<String> olwKeys = olwJson.keys();
                        while (olwKeys.hasNext()) {
                            JSONObject bankCodeJson = olwJson.optJSONObject(olwKeys.next());
                            if (bankCodeJson != null) {
                                boolean isMPinSet = bankCodeJson.optBoolean(PayuConstants.PAYU_IS_MPIN_SET);
                                boolean customerRegistered = bankCodeJson.optBoolean(PayuConstants.PAYU_CUSTOMER_REGISTERED);
                                OlwSDKInfo olwSDKInfo = new OlwSDKInfo();
                                olwSDKInfo.setMPinSet(isMPinSet);
                                olwSDKInfo.setCustomerRegistered(customerRegistered);
                                sodexoCardInfo.setCardBalance(bankCodeJson.optString(PayuConstants.PAYU_BALANCE));
                                sodexoCardInfo.setOlwSDKInfo(olwSDKInfo);
                            }
                        }

                    }
                } else {
                    sodexoCardInfo.setCardNo(jsonResponse.optString(PayuConstants.CARDNO));
                    sodexoCardInfo.setCardBalance(jsonResponse.optString(PayuConstants.CARD_BALANCE));
                    sodexoCardInfo.setCardName(jsonResponse.optString(PayuConstants.CARDNAME));
                    sodexoCardInfo.setMsg(jsonResponse.optString(PayuConstants.MSG));
                    JSONObject olwJson = jsonResponse.optJSONObject(PayuConstants.OLW);
                    if (olwJson != null) {
                        Iterator<String> olwKeys = olwJson.keys();
                        while (olwKeys.hasNext()) {
                            JSONObject bankCodeJson = olwJson.optJSONObject(olwKeys.next());
                            if (bankCodeJson != null) {
                                boolean isMPinSet = bankCodeJson.optBoolean(PayuConstants.PAYU_IS_MPIN_SET);
                                boolean customerRegistered = bankCodeJson.optBoolean(PayuConstants.PAYU_CUSTOMER_REGISTERED);
                                OlwSDKInfo olwSDKInfo = new OlwSDKInfo();
                                olwSDKInfo.setMPinSet(isMPinSet);
                                olwSDKInfo.setCustomerRegistered(customerRegistered);
                                sodexoCardInfo.setCardBalance(bankCodeJson.optString(PayuConstants.PAYU_BALANCE));
                                sodexoCardInfo.setOlwSDKInfo(olwSDKInfo);
                            }
                        }

                    }
                }
                payuResponse.setSodexoCardInfo(sodexoCardInfo);

            }
        } catch (MalformedURLException e) {
            Log.d(TAG, "ProtocolException " + e.getMessage());
        } catch (ProtocolException e) {
            Log.d(TAG, "ProtocolException " + e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, "ProtocolException " + e.getMessage());
        } catch (JSONException e) {
            Log.d(TAG, "ProtocolException " + e.getMessage());
        }
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        checkBalanceListener.onCheckBalanceResponse(payuResponse);
    }
}
