package com.payu.india.Tasks;

import static com.payu.paymentparamhelper.PayuConstants.DATA;

import android.util.Log;

import com.payu.india.Interfaces.V2ApiResponseListener;
import com.payu.india.Model.ApiResponse;
import com.payu.india.Model.CardInformation;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PostData;
import com.payu.india.Model.binBaseDetails.BinBaseDetailsResponse;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeCombinations;
import com.payu.india.Model.validateOffer.ValidateOfferDetails;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Payu.v2ApiResponseParser.V2ApiResponseParser;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

import javax.net.ssl.HttpsURLConnection;

public class BinBaseDetailsTask extends PayUAsyncTask<PayuConfig, String, ApiResponse<BinBaseDetailsResponse>> {

    private final String TAG = this.getClass().getSimpleName();

    private final V2ApiResponseListener<ApiResponse<BinBaseDetailsResponse>> v2ApiResponseListener;

    public BinBaseDetailsTask(V2ApiResponseListener<ApiResponse<BinBaseDetailsResponse>> v2ApiResponseListener) {
        this.v2ApiResponseListener = v2ApiResponseListener;
    }

    @Override
    protected ApiResponse<BinBaseDetailsResponse> doInBackground(PayuConfig... params) {
        Log.d(TAG, "doInBackground");

        String payuResponse = "";
        ApiResponse<BinBaseDetailsResponse> apiResponse = new ApiResponse<>();
        PostData postData = new PostData();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];
            // set the environment
            //Todo: To be changed later
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_APIV2_URL);
                    break;
                default:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
            }

            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).
                    setURL(url + PayuConstants.PAYU_BIN_BASE_DETAILS).setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader(PayuConstants.PAYU_BIN_BASE)).
                    setRequestType(PayuConstants.REQUEST_APPLICATION_JSON).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);

            if (null != conn) {
                StringBuilder responseStringBuffer = PayuUtils.getStringBuilder(conn, false);

                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                apiResponse.setRawResponse(jsonResponse);
                if (jsonResponse.has(PayuConstants.STATUS) && jsonResponse.optInt(PayuConstants.STATUS) == 0) {
                    postData.setCode(PayuErrors.GET_BIN_INFO_API_EXCEPTION);
                    postData.setStatus(PayuConstants.ERROR);
                    postData.setResult(jsonResponse.optString(DATA) != null ? jsonResponse.optString(DATA) : PayuConstants.SOMETHING_WENT_WRONG_ERROR);
                } else if (jsonResponse.optInt(PayuConstants.STATUS) == 1) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                    BinBaseDetailsResponse binBaseDetailsResponse = new BinBaseDetailsResponse();
                    CardInformation cardInformation = new CardInformation();
                    V2ApiResponseParser v2ApiResponseParser = new V2ApiResponseParser();
                    v2ApiResponseParser.parseBinInfoResponse(jsonResponse, cardInformation);
                    ValidateOfferDetails validateOfferDetails = new ValidateOfferDetails();
                    JSONObject validateJson = jsonResponse.optJSONObject(PayuConstants.PAYU_VALIDATE_OFFER_DATA);
                    binBaseDetailsResponse.setCardInformation(cardInformation);
                    if (validateJson != null) {
                        JSONObject validateOfferJsonResult = validateJson.optJSONObject(PayuConstants.P_RESULT);
                        if (validateOfferJsonResult != null) {
                            v2ApiResponseParser.parseValidateOfferResponse(validateOfferJsonResult, validateOfferDetails);
                            binBaseDetailsResponse.setValidateOfferDetails(validateOfferDetails);
                        }
                    }

                    JSONObject pricingCfJson = jsonResponse.optJSONObject(PayuConstants.PAYU_PRICING_CF_DATA);
                    if (pricingCfJson != null) {
                        JSONObject data = pricingCfJson.optJSONObject(DATA);
                        HashMap<String, FetchConvFeeCombinations> convFeeMap = v2ApiResponseParser.parseFetchConvFeeRespToMap(data);
                        binBaseDetailsResponse.setConvFeeChargesMap(convFeeMap);
                    }
                    apiResponse.setPayuResponse(binBaseDetailsResponse);
                }
            }
        } catch (MalformedURLException e) {
            Log.d(TAG, " MalformedURLException" + e.getMessage());
            postData.setCode(PayuErrors.MALFORMED_URL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, " MalformedURLException" + e.getMessage());
            postData.setCode(PayuErrors.IO_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (JSONException e) {
            Log.d(TAG, " JSONException" + e.getMessage());
            postData.setCode(PayuErrors.JSON_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        }
        apiResponse.setPostData(postData);
        return apiResponse;
    }

    @Override
    protected void onPostExecute(ApiResponse<BinBaseDetailsResponse> apiResponse) {
        super.onPostExecute(apiResponse);
        v2ApiResponseListener.onApiResponse(apiResponse);
    }
}
