//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Payu;


/**
 * Created by franklin on 5/30/15.
 * Payu Errors
 * when SDK validates the post params (paymentDefaultParams, CCDCParams, NetbankingParams, CashCardParam, Emi params, paisawallet param)
 * any one of these error code, proper error message should be return via postParam
 */
public interface PayuErrors extends com.payu.paymentparamhelper.PayuErrors {

    //prefix and postfix
    String CARD_PREIX = PRE_PREIX + "card ";
    String INVALID_PREIX1 = "Please enter valid ";


    int INVALID_PG_EXCEPTION = 5006;
    int INVALID_CARD_TOKEN_EXCEPTION = 5007;
    int INVALID_MONTH_EXCEPTION = 5010;
    int INVALID_YEAR_EXCEPTION = 5011;
    int INVALID_USER_CREDENTIALS = 5014;
    int JSON_EXCEPTION = 5014;
    int NO_SUCH_ALGORITHM_EXCEPTION = 5015;
    int PROTOCOL_EXCEPTION = 5016;
    int IO_EXCEPTION = 5016;
    int PENDING_TRANSACTION = 5202;
    int SOME_ERROR = 5500;

    int DELETE_CARD_EXCEPTION = 5017;
    int GET_USER_CARD_EXCEPTION = 5018;

    int INVALID_HASH = 5019;

    int APPLICATION_NOT_FOUND_EXCEPTION = 5020;
    int METHOD_NOT_SUPPORTED = 5021;
    int MALFORMED_URL_EXCEPTION = 5022;
    int ILLEGAL_ARGUMENT_EXCEPTION = 5023;
    int ARRAY_OUT_OF_BOUND_EXCEPTION = 5024;

    String MANDATORY_PARAM_VAR1_IS_MISSING = MANDATORY_PARAM_PREIX + "var1" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR2_IS_MISSING = MANDATORY_PARAM_PREIX + "var2" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR3_IS_MISSING = MANDATORY_PARAM_PREIX + "var3" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR4_IS_MISSING = MANDATORY_PARAM_PREIX + "var4" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR5_IS_MISSING = MANDATORY_PARAM_PREIX + "var5" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR6_IS_MISSING = MANDATORY_PARAM_PREIX + "var6" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR7_IS_MISSING = MANDATORY_PARAM_PREIX + "var7" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR8_IS_MISSING = MANDATORY_PARAM_PREIX + "var8" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR9_IS_MISSING = MANDATORY_PARAM_PREIX + "var9" + IS_MISSING_POSTIX;


    String MANDATORY_PARAM_SALT_IS_MISSING = MANDATORY_PARAM_PREIX + "salt" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_COMMAND_IS_MISSING = MANDATORY_PARAM_PREIX + "command" + IS_MISSING_POSTIX;


    String MANDATORY_PARAM_BANK_CODE_IS_MISSING = MANDATORY_PARAM_PREIX + "bankcode" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_PG_IS_MISSING = MANDATORY_PARAM_PREIX + "pg is missing, pg should be any one of CC, EMI, CASH, NB, PAYU_MONEY";

    String TRANSACTION_ID_MISSING = PRE_PREIX + "Transaction id (txnid)";
    String MIHPAY_ID_MISSING = PRE_PREIX + "Payu id (mihpayid) of the transaction which was given by payu.";
    String CARD_TOKEN_MISSING = PRE_PREIX + "card token, you get the card token when you store/fetch a card";
    String USER_CREDENTIALS_OR_DEFAULT_MISSING = " should be user_credentials (merchant_key:unique_user_id.) to get the merchant information and stored card or default to get only the merchant information";
    String CARD_NUMBER_MISSING = " should be a valid credit / debit card number";
    String NAME_ON_CARD_MISSING = " should be name on card";


    String CARD_TYPE_MISSING = CARD_PREIX + "type; please use CC as card type";
    String CARD_MODE_MISSING = CARD_PREIX + "mode; please use CC as card mode";
    String CARD_NAME_MISSING = CARD_PREIX + "name (nickname of the card)";

    String CARD_BIN_MISSING = "number or the card bin (first 6 digit of the card)";
    String END_DATE_TIME_MISSING = PRE_PREIX + "till date in YYYY-MM-DD hh:mm:ss format.";
    String FROM_DATE_TIME_MISSING = PRE_PREIX + "from date in YYYY-MM-DD hh:mm:ss format";
    String END_DATE_MISSING = "till date in YYYY-MM-DD format.";
    String FROM_DATE_MISSING = PRE_PREIX + "from date in YYYY-MM-DD format";
    String BANK_CODE_MISSING = PRE_PREIX + "bank code for one bank, default for getting all banks";
    String OFFER_KEY_MISSING = " should be offer key example : offer@1234 ";
    String POST_DATA_MISSING = "Post data is missing";


    String INVALID_YEAR = " Invalid year, year should be 4 digit YYYY format";
    String INVALID_MONTH = " Invalid month, it should be two digit number range from 01 to 12 MM format";
    String INVALID_JSON = " should be a stringified JSON object; It seems there is an exception while parsing JSON";
    String INVALID_AMOUNT_TO_REFUND = "  should contain the amount which needs to be refunded. Please note that both partial and full refunds are allowed.";
    String INVALID_TOKEN_ID = PRE_PREIX + "Token ID(unique token from merchant)";
    String INVALID_BANK_REFERENCE_ID = PRE_PREIX + "Bank Ref Id for the requested transaction.";
    String INVALID_ACTION = PRE_PREIX + "Action (cancel/capture/refund)";
    String INVALID_BANK_CODE_CC = "For credit card payment bank code should be CC";
    String INVALID_PAYMENT_OPTION = " Invalid card payment option. ccnum / card_token missing.";
    String INVALID_CARD_TOKEN = " Invalid card token";
    String INVALID_ALGORITHM_SHA = " Message digest sha 512 not found!";
    String INVALID_PRODUCT_INFO = "Product info should not be null, it can be empty or string";
    String INVALID_FIRST_NAME = "First name should not be null, it can be empty or string";
    String INVALID_EMAIL = "Email should not be null, it can be empty or string";

    String INVALID_SALT = "Salt should be a valid string";


    String INVALID_POST_PARAMS = INVALID_PREIX1 + "MerchantWebService object / PaymentDefaultParams and PaymnentModeParam";
    String INVALID_PAYMENT_DEFAULT_PARAMS = INVALID_PREIX1 + "PaymentDefaultParamsObject";
    String INVALID_PAYMENT_MODES = INVALID_PREIX2 + "PaymentModes (Anyone from NB, CASH, EMI, CC, PAYU_MONEY)";
    String INVALID_CARD_DETAILS = INVALID_PREIX2 + "card details (card number , cvv, exp month, exp year, card name)";
    String INVALID_USER_CREDENTIALS_MISSING = " Invalid user credentials, user_credentials should be merchant_key:unique_user_id.";

    String USE_DEFAULT = " Please send var1 as 'default'";
    String MORE_THAN_ONE_TXNID = "if you want to verify more than one transaction please separate them by pipe : ex 6234567|45678987|4567876 ";
    String NEW_STATUS = " should be new status to be set";
    String REQUEST_ID = PRE_PREIX + "Request ID which you get while cancel_refund_transaction api";

    String ERROR_INVALID_MERCHANT_ACCESS_KEY = "Invalid merchantAccessKey";
    String ERROR_INVALID_AMOUNT = "Invalid amount";
    String ERROR_INVALID_CURRENCY = "Invalid currency";
    String ERROR_INVALID_CARD_BIN = "Invalid cardBin";
    String ERROR_INVALID_MERCHANT_ORDER_ID = "Invalid merchantOrderId";
    String ERROR_INVALID_PRODUCT_TYPE = "Invalid productType";
    String ERROR_INVALID_SIGNATURE = "Invalid signature";
    String ERROR_SOME_ERROR_OCCURRED = "Some error occurred";

    // no error block
    String SDK_DETAILS_FETCHED_SUCCESSFULLY = "Data fetched successfully, Stored card status: ";
    String DETAILS_FETCHED_SUCCESSFULLY = "Data fetched successfully";

    String VPA_NO_AMPERSAND = "virtual address should contain @";
    String VPA_RULE = "VPA can only be in format: A-Z a-z 1-9.@ A-Z a-z 1-9";


    // Applction context not found in Payu.java file.
    String APP_CONTEXT_NOT_FOUND = "Application context not found please set your applciation context by adding Payu.setInstance(this) from your activity ";
    int GET_BIN_INFO_API_EXCEPTION = 5050;
    String INVALID_SI_DETALS = "SI details should be a valid json object";

    int ERROR_CODE_INVALID_IFSC_DETAILS = 5051;
    String ERROR_INVALID_IFSC_DETAILS = "Invalid IFSC Details";
    String ERROR_TOO_MANY_IFSC_REQUESTS = "Oops! Too many requests. Please try after sometime";
    String ERROR_IFSC_NOT_FOUND = "IFSC not found";
    String ERROR_SAVE_IMPRESSION = "Invalid Request";
    String ERROR_SAVE_PAYU_ID = "Invalid RequestID";
    String ERROR_INVALID_GAID ="Invalid GAID Request";
    int INFO_API_EXCEPTION = 5052;
}
