//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Payu;


import java.security.PublicKey;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by franklin on 5/31/15.
 * Payu constants
 * User can make use in API request, response, bundles, validations etc,
 */
public interface PayuConstants extends com.payu.paymentparamhelper.PayuConstants {

    int PAYU_REQUEST_CODE = 100;

    // Environments
    String ENV = "env";
    String PAYU_CONFIG = "payuConfig";
    int PRODUCTION_ENV = 0;
    int MOBILE_STAGING_ENV = 1; // mobiletest.payu.in
    int STAGING_ENV = 2; // test.payu.in
    int MOBILE_DEV_ENV = 3; // mobiledev.payu.in
    int BIZCHECKOUT_TEST_ENV = 4; // bizcheckouttest.payu.in

    // webservice api constants

    // var collections
    String VAR1 = "var1";
    String VAR2 = "var2";
    String VAR3 = "var3";
    String VAR4 = "var4";
    String VAR5 = "var5";
    String VAR6 = "var6";
    String VAR7 = "var7";
    String VAR8 = "var8";
    String VAR9 = "var9";
    String VAR10 = "var10";
    String VAR11 = "var11";
    String VAR12 = "var12";
    String VAR13 = "var13";
    String VAR14 = "var14";
    String VAR15 = "var15";
    String DISCOVER = "DISCOVER";
    String MASTERCARD = "MASTERCARD";
    String SMS_PERMISSION = "sms_permission";
    String COMMAND = "command";
    String SALT = "salt";

    // commands

    String VERIFY_PAYMENT = "verify_payment";
    String CHECK_PAYMENT = "check_payment";
    String CANCEL_REFUND_TRANSACTION = "cancel_refund_transaction";
    String CHECK_ACTION_STATUS = "check_action_status";
    String CAPTURE_TRANSACTION = "capture_transaction";
    String UPDATE_REQUESTS = "update_requests";
    String COD_VERIFY = "cod_verify";
    String COD_CANCEL = "cod_cancel";
    String COD_SETTLED = "cod_settled";
    String GET_TDR = "get_TDR";
    String UDF_UPDATE = "udf_update";
    String CREATE_INVOICE = "create_invoice";
    String CHECK_OFFER_STATUS = "check_offer_status";
    String GET_TRANSACTION_DETAILS = "get_Transaction_Details";
    String GET_TRANSACTION_INFO = "get_transaction_info";
    String CHECK_IS_DOMESTIC = "check_isDomestic";
    @Deprecated
    String GET_USER_CARDS = "get_user_cards";
    @Deprecated
    String SAVE_USER_CARD = "save_user_card";
    @Deprecated
    String EDIT_USER_CARD = "edit_user_card";
    @Deprecated
    String DELETE_USER_CARD = "delete_user_card";
    String VAS_FOR_MOBILE_SDK = "vas_for_mobile_sdk";
    String ELIGIBLE_BINS_FOR_EMI = "eligibleBinsForEMI";
    String PAYMENT_RELATED_DETAILS_FOR_MOBILE_SDK = "payment_related_details_for_mobile_sdk";
    String GET_CHECKOUT_DETAILS = "get_checkout_details";
    String DELETE_STORE_CARD_CVV = "delete_store_card_cvv";

    String MERCHANT_CVV_DATA = "merchant_cvv_data";
    //Only Hash Generation Support
    String VALIDATE_VPA = "validateVPA";
    String GET_HASHES = "get_hashes";
    // status
    String ERROR = "ERROR";
    String SUCCESS = "SUCCESS";
    String STATUS = "status";
    String DETAILS = "details";
    String OFFERS = "offers";
    String IS_USER_PERSONALIZED_OFFER_AVAILABLE = "isUserPersonalizedOffersAvailable";
    String IS_ELIGIBLE = "isEligible";
    String MIN_AMOUNT = "minAmount";
    String CARD_BINS = "cardBins";
    String BIN = "bin";
    String METHOD_NOT_SUPPORTED = "method not supported";
    String CHECK_OFFER_DETAILS = "check_offer_details";
    //v2 api end points
    String VALIDATEOFFER_API_ENDPOINT = "offers/transactions/validate";

    String CALCULATE_EMI = "calculateEmi/v3";
    String FETCHOFFER_API_ENDPOINT = "offers/transactions";
    String FETCH_ADS_API_ENDPOINT = "ads/FetchAssets";
    String ADS_UPDATE_PAYUID_API_ENDPOINT = "ads/update_payuId";
    String ADS_IMPRESSION_API_ENDPOINT = "sdk/ads/impression";
    String QUICK_PAY_API_ENDPOINT = "recommendation/v1/fetch";

    //URL Global Vault
    String GLOBALVAULT_SENDOTP_API_ENDPOINT = "otp/sdk/send";
    String GLOBALVAULT_RESENDOTP_API_ENDPOINT = "otp/sdk/resend";
    String GLOBALVAULT_VERIFYOTP_API_ENDPOINT = "otp/sdk/verify";

    String PAYU_DELETE_API_ENDPOINT = "sdk/instrumentDetail/consent";
    String PAYU_BIN_BASE_DETAILS = "sdk/card/binDetails";
    String PAYU_FETCH_CONV_FEE = "sdk/checkoutx/fetchConvenienceFee";
    String PAYU_SEND_OTP_ENDPOINT = "loyalty-points/ppi/v1/otp/send";
    String PAYU_SET_MPIN_ENDPOINT = "loyalty-points/ppi/v1/set-reset/mpin";
    String PAYU_VERIFY_MPIN_ENDPOINT = "loyalty-points/ppi/v1/verifyMpinDeviceIdToken";

    // Response data

    String IBIBO_CODES = "ibiboCodes";
    String PAYMENT_OPTIONS = "paymentOptions";
    String CONFIG = "config";
    String DOWN_INFO = "downInfo";
    String P_MERCHANT = "merchant";
    String PAYU_CC = "cc";
    String PAYU_DC = "dc";
    String PAYU_OTHER = "other";
    String PAYU_CARDLESS = "cardless";
    String PAYU_NB = "nb";
    String PAYU_SI = "si";
    String PAYU_NEFTRTGS = "neftrtgs";
    String PAYU_CASH = "cash";
    String PAYU_UPI_OTM = "upiotm";
    String PAYU_ALL = "all";
    String TENURE_OPTIONS = "tenureOptions";
    String TENURE_OPTION = "tenureOption";
    String ELIGIBILITY = "eligibility";
    String ELIGIBILITY_STATUS = "status";
    String ELIGIBILITY_REASON = "reason";
    String NETBANKING = "netbanking";
    String NETBANKING_OFFER = "netBanking";
    String NETWORK = "networks";
    String USERCARDS = "userCards";
    String CASHCARD = "cashcard";
    String CREDITCARD = "creditcard";
    String P_CREDITCARD = "creditCard";
    String DEBITCARD = "debitcard";
    String P_DEBITCARD = "debitCard";
    String IVR = "ivr";
    String IVRDC = "ivrdc";
    String PAISAWALLET = "paisawallet";
    String LAZYPAY = "lazypay";
    String SODEXO = "SODEXO";
    String MC = "mc";
    String BANK = "bank";
    String P_BANKS = "banks";
    String PAYUW = "PAYUW";
    String WALLET = "wallet";
    String CARD = "card";
    String LOGO = "logo";
    String DISPLAYNAME = "displayName";
    String RETRYALLOWED = "retryAllowed";
    String P_BNPL = "bnpl";
    String HDFC = "HDFC";

    String PG_ID = "pgId";
    String SHOW_FORM = "show_form";
    String PT_PRIORITY = "pt_priority";
    String MINKASUIBIBOCODES = "minkasuIbiboCodes";

    // user cards

    String USER_CARD = "user_cards";
    String NAME_ON_CARD = "name_on_card";
    String CARD_NAME = "card_name";
    String EXPIRY_YEAR = "expiry_year";
    String EXPIRY_MONTY = "expiry_month";
    String CARD_TYPE = "card_type";
    String CARD_TOKENS = "card_tokens"; // we have it already
    String CARD_TOKEN = "card_token"; // we have it already
    String IS_EXPIRED = "is_expired";
    String CARD_MODE = "card_mode";
    String CARD_NO = "card_no";
    String CARD_BRAND = "card_brand";
    String CARD_BIN = "card_bin";
    String IS_DOMESTIC = "isDomestic";
    String ISSUINGBANK = "issuingBank";
    String CARDTYPE = "cardType";
    String CARDCATEGORY = "cardCategory";
    String CARD_PAR = "card_PAR";
    String PAR = "PAR";

    //sodexo check balance
    String CARDNO = "cardNo";
    String CARDNAME = "cardName";
    String CARD_BALANCE = "cardBalance";

    String ONE_CLICK_CARD_TOKENS = "one_click_card_tokens";
    String STORE_ONE_CLICK_HASH = "store_one_click_hash";
    int STORE_ONE_CLICK_HASH_NONE = 0;
    int STORE_ONE_CLICK_HASH_SERVER = 1;
    int STORE_ONE_CLICK_HASH_MOBILE = 2;

    // offer related API constants.
    String ERROR_CODE = "error_code";
    String DISCOUNT = "discount";
    String DISCOUNT_UNIT = "discount_unit";
    String CATEGORY = "category";
    String OFFER_TYPE = "offer_type";
    String VALID_ON_DAYS = "valid_on_days";
    String OFFER_AVAILED_COUNT = "offer_availed_count";
    String OFFER_REMAINING_COUNT = "offer_remaining_count";
    String ALLOWED_ON = "allowed_on";
    String DATA_KEY = "data_key";
    String CARD_DATA = "card_data";
    String OFFER_DATA = "offer_data";

    String TRANSACTION_DETAILS = "transaction_details";
    String MIHPAY_ID = "mihpayid";
    String REQUEST_ID = "request_id";
    String BANK_REF_NUM = "bank_ref_num";
    String AMT = "amt";
    String MERCHANT_ADDITIONAL_CHARGES = "merchantAdditionalCharges";
    String FIELD1 = "field1";
    String FIELD2 = "field2";
    String FIELD3 = "field3";
    String FIELD4 = "field4";
    String FIELD9 = "field9";
    String ERROR_MESSAGE = "error_Message";
    String ERROR_MESSAGE2 = "Error_Message";
    String NET_AMOUNT_DEBIT = "net_amount_debit";
    String DISC = "disc";
    String MODE = "mode";
    String TRANSACTION_AMOUNT = "transaction_amount";
    String PG_TYPE = "PG_TYPE";
    String ADDED_ON = "addedon";
    String UNMAPPED_STATUS = "unmappedstatus";
    String MERCHANT_UTR = "Merchant_UTR";
    String SETTLED_AT = "Settled_At";

    String PAYU_RESPONSE = "payu_response";


    // net banking

    String BANK_ID = "bank_id";
    String TITLE = "title";
    String DESCRIPTION = "description";
    String PAYU_MIN_AMOUNT = "min_amount";
    String SHORT_TITLE = "shortTitle";
    String ADDITIONAL_CHARGE = "additionalCharge";
    String TAX_SPECIFICATION = "taxSpecification";
    String ISSUING_BANKS = "issuingBanks";
    String BANK_CODE_RESPONSE = "bank_code";
    String PGID = "pgId";
    String PAYU_PGTITLE = "pgTitle";
    String PAYU_PGDETAILS = "pgDetails";
    String PAYU_IBIBOCODE = "ibiboCode";
    String PAYU_PGDISPLAY = "pgDisplay";
    String PAYU_PGUP = "pgUP";
    String PAYU_IS_TOKENTXN = "tokenTxn";

    String POST_DATA = "post_data";
    String MSG = "msg";
    String EMI_IN_RESPONSE = "emi";
    String EMI_MIN_AMOUNT = "min_amount";
    String EMI_MINIMUM_AMOUNT = "minimumAmount";
    String EMI_MAXIMUM_AMOUNT = "maximumAmount";
    String EMI_INTEREST_RATE = "interestRate";
    String EMI_MONTHLY = "monthlyEmi";
    String EMI_INTEREST_CHARGED = "interestCharged";
    String EMI_PAYBACK_AMOUNT = "paybackAmount";

    String NO_COST_EMI = "no_cost_emi";

    // for bundle
    @Deprecated
    String PAYMENT_DEFAULT_PARAMS = "payment_default_params";
    String PAYU_HASHES = "payu_hashes";
    String PAYMENT_PARAMS = "payment_params";
    String ONE_CLICK_PAYMENT = "one_click_payment";

    // sets and lists

    Set<String> COMMAND_SET = new HashSet<String>();
    // test env
    String TEST_PAYMENT_URL = "https://test.payu.in/_payment";
    //        String TEST_PAYMENT_URL = "https://pp93secure.payu.in/_payment";
    String TEST_FETCH_DATA_URL = "https://test.payu.in/merchant/postservice?form=2";
    //        String TEST_FETCH_DATA_URL = "https://pp93info.payu.in/merchant/postservice?form=2";
    // mobile dedicated test env
    String MOBILE_TEST_PAYMENT_URL = "https://test.payu.in/_payment";
    String MOBILE_TEST_FETCH_DATA_URL = "https://test.payu.in/merchant/postservice?form=2";

    String MOBILE_DEV_PAYMENT_URL = "https://mobiledev.payu.in/_payment";
    String MOBILE_DEV_FETCH_DATA_URL = "https://mobiledev.payu.in/merchant/postservice?form=2";

    String TEST_DEMO_PAYMENT_URL = "https://demotest.payu.in/_payment";
    String TEST_DEMO_FETCH_DATA_URL = "https://demotest.payu.in/merchant/postservice?form=2";

    String BIZ_CHECKOUT_TEST_PAYMENT_URL = "https://bizcheckouttest.payu.in/_payment";
    String BIZ_CHECKOUT_TEST_FETCH_DATA_URL = "https://bizcheckouttest.payu.in/merchant/postservice?form=2";

    // production
    String PRODUCTION_PAYMENT_URL = "https://secure.payu.in/_payment";
    String PRODUCTION_FETCH_DATA_URL = "https://info.payu.in/merchant/postservice.php?form=2";

    //Citrus Urls
    String TEST_LOOKUP_URL = "https://sboxmercury.citruspay.com/multi-currency-pricing/mcp/lookup";
    String PRODUCTION_LOOKUP_URL = "https://mercury.citruspay.com/multi-currency-pricing/mcp/lookup";

    //Url to fetch IFSC Code Details
    String IFSC_CODE_URL = "sdk/verifyIFSC";

    String TEST_APIV2_URL = "https://sandbox.payu.in/";
    //    String TEST_APIV2_URL = "https://pp93api.payu.in/";
    //TEMP: VARIABLE WILL BE REMOVED. ONCE QUICKPAY IS LIVE
    String APIV2_URL = "https://api.payu.in/";


    //    String PRODUCTION_GLOBALVAULT_FETCH_URL ="https://pp93api.payu.in/quickpay/fetch";
    String PRODUCTION_GLOBALVAULT_FETCH_URL = "https://api.payu.in/quickpay/fetch";

    //Keys for Device Tracking for transaction
    String SDK_VERSION_NAME = "sdk_version";
    String CB_VERSION_NAME = "cb_version";
    String DEVICE_OS_VERSION = "os_version";
    String NETWORK_INFO = "network_info";
    String NETWORK_STRENGTH = "network_strength";
    String DEVICE_RESOLUTION = "resolution";
    String DEVICE_MANUFACTURE = "device_manufacturer";
    String DEVICE_MODEL = "device_model";
    String MERCHANT_KEY = "merchant_key";
    String TRANSACTION_ID = "txnid";

    // Shared preference file name
    String PAYU_PREFERENCE = "PayuPreference";

    String MERCHANT_HASH = "merchant_hash";

    String ID = "id";
    String TRANSACTION_FEE = "transaction_fee";
    String PAYMENT_SOURCE = "payment_source";
    String IBIBO_CODE = "ibibo_code";
    String IS_SEAMLESS = "is_seamless";

    // subvention amount - used with payment url (_payment)
    String SUBVENTION_AMOUNT = "subvention_amount";

    String MERCHANT_SUBVENTION_AMOUNT = "merchant_subvention_amount";

    // Flag for storing the merchant hash in mobile device.
    String STORE_MERCHANT_HASH = "store_merchant_hash";

    // store card duplicate check constants
    String DUPLICATE_CARDS_COUNT = "duplicate_cards_count";


    INIT init = new INIT();

    // ####################################################### //
    // ## CONSTANTS FOR GetEmiAmountAccordingToInterest API ## //
    // ####################################################### //
    String EMI_BANK_INTEREST = "emiBankInterest";
    String BANK_RATE = "bankRate";
    String BANK_CHARGE = "bankCharge";
    String EMI_VALUE = "emi_value";
    String EMI_INTEREST_PAID = "emi_interest_paid";
    String EMI_TENURE = "tenure";
    // Command
    String API_GET_EMI_AMOUNT_ACCORDING_INTEREST = "getEmiAmountAccordingToInterest";
    // ####################################################### //

    String PAYU_IMEI = "imei";
    String PAYU_UDID = "udid";

    //Analytics
    String PLATFORM_KEY = "platform";
    String PLATFORM_VALUE = "android";
    String SDK_PLATFORM_KEY = "sdk_platform";
    String NAME_KEY = "name";
    String NAME_VALUE = "coresdk";
    String VERSION_KEY = "version";

    String P_REQUEST_ID = "requestId";
    String P_AMOUNT = "amount";
    String P_TRANSACTION_DETAILS = "transactionDetails";
    String P_GET_ADDITIONAL_CHARGES = "getAdditionalCharges";
    String P_GET_TAX_SPECIFICATION = "getTaxSpecification";
    String P_CHECK_DOWN_STATUS = "checkDownStatus";
    String P_GET_OFFER_DETAILS = "getOfferDetails";
    String P_GET_EXTENDED_PAYMENT_DETAILS = "getExtendedPaymentDetails";
    String P_USE_CASE = "useCase";
    String P_PRE_AUTHORIZE = "pre_authorize";
    String P_CUSTOMER_DETAILS = "customerDetails";
    String P_MOBILE = "mobile";
    String P_FILTERS = "filters";
    String P_PAYMENTOPTIONS = "paymentOptions";
    String P_CHECKCUSTOMER_ELIGIBILITY = "checkCustomerEligibility";
    String P_GET_MERCHANT_DETAILS = "getMerchantDetails";
    String P_GET_SDK_DETAILS = "getSdkDetails";
    String P_RESULT = "result";
    String P_GET_PAYMENT_DETAILS_WITH_EXTRA_FIELDS = "getPaymentDetailsWithExtraFields";
    String P_IFSC_CODES = "ifscCodes";
    String P_IFSC_CODE = "ifscCode";


    class INIT {
        static {

            //COMMAND_SET
            COMMAND_SET.add(GET_CHECKOUT_DETAILS);
            COMMAND_SET.add(VERIFY_PAYMENT);
            COMMAND_SET.add(CHECK_PAYMENT);
            COMMAND_SET.add(CANCEL_REFUND_TRANSACTION);
            COMMAND_SET.add(CHECK_ACTION_STATUS);
            COMMAND_SET.add(CAPTURE_TRANSACTION);
            COMMAND_SET.add(UPDATE_REQUESTS);
            COMMAND_SET.add(COD_VERIFY);
            COMMAND_SET.add(COD_CANCEL);
            COMMAND_SET.add(COD_SETTLED);
            COMMAND_SET.add(GET_TDR);
            COMMAND_SET.add(UDF_UPDATE);
            COMMAND_SET.add(CREATE_INVOICE);
            COMMAND_SET.add(CHECK_OFFER_STATUS);
            COMMAND_SET.add(GET_NETBANKING_STATUS);
            COMMAND_SET.add(GET_ISSUING_BANK_STATUS);
            COMMAND_SET.add(GET_TRANSACTION_DETAILS);
            COMMAND_SET.add(GET_TRANSACTION_INFO);
            COMMAND_SET.add(CHECK_IS_DOMESTIC);
            COMMAND_SET.add(GET_USER_CARDS);
            COMMAND_SET.add(SAVE_USER_CARD);
            COMMAND_SET.add(EDIT_USER_CARD);
            COMMAND_SET.add(DELETE_USER_CARD);
            COMMAND_SET.add(GET_MERCHANT_IBIBO_CODES);
            COMMAND_SET.add(VAS_FOR_MOBILE_SDK);
            COMMAND_SET.add(PAYMENT_RELATED_DETAILS_FOR_MOBILE_SDK);
            COMMAND_SET.add(MOBILE_HASH_TEST_WS);
            COMMAND_SET.add(GET_HASHES);
            COMMAND_SET.add(CHECK_OFFER_DETAILS);
            // For getEmiAmountAccordingToInterest
            COMMAND_SET.add(API_GET_EMI_AMOUNT_ACCORDING_INTEREST);
            // For EMI eligibility
            COMMAND_SET.add(ELIGIBLE_BINS_FOR_EMI);
            // for testing.
            COMMAND_SET.add(MERCHANT_CVV_DATA);
            COMMAND_SET.add(DELETE_STORE_CARD_CVV);
            COMMAND_SET.add(VALIDATE_VPA);
            COMMAND_SET.add(GET_BIN_INFO);
            COMMAND_SET.add(GET_TOKENISED_USER_CARD);
            COMMAND_SET.add(DELETE_TOKENISED_USER_CARD);
            COMMAND_SET.add(GET_TOKENISED_CARD_DETAILS);
            COMMAND_SET.add(CHECK_BALANCE);
            COMMAND_SET.add(SDK_CONFIGURATION);
        }

        INIT() {
            super();
        }

        String HDFC = "HDFC";
        String ICICI = "ICICI";
        String CITI = "CITI";
        String HSBC = "HSBC";
        String IDBI = "IDBI";
        String INDUSIND = "INDUS";
        String ING = "ING";
        String KOTAK = "KOTAK";
        String SBIDC = "SBIDC";
        String SC = "SC";
        String YES = "YES";
        String CARD_CVV = "card_cvv";
        String ONE_CLICK_CHECKOUT = "one_click_checkout"; // can be 0 or 1; 0 - payu does not have cvv, 1 - payu has cvv
        String CARD_MERCHANT_PARAM = "card_merchant_param"; // should be passed with other payment params, should be taken from Shared preferences.
        String INSTRUMENT_TYPE = "instrument_type";
        String INSTRUMENT_ID = "instrument_id";
    }

    String SI_IN_RESPONSE = "standinginstruction";
    String GET_BIN_INFO = "getBinInfo";
    String CHECK_BALANCE = "check_balance";

    String BIN_INFO_ISSUING_BANK = "issuing_bank";
    String BIN_INFO_BIN_VALUE = "bin";
    String BIN_INFO_CARD_CATEGORY = "category";
    String BIN_INFO_CARD_TYPE = "card_type";
    String BIN_INFO_IS_SI_SUPPORTED = "is_si_supported";
    String BIN_INFO_IS_DOMESTIC = "is_domestic";
    String SI_DETAILS = "si_details";
    String SINETBANKING = "sinetbanking";
    String ENACH = "enach";
    String CCSI = "CCSI";
    String DCSI = "DCSI";
    String HDFCDCSI = "HDFCDCSI";
    String UPISI = "UPISI";
    String INTENTSI = "INTENTSI";

    String BIN_INFO_IS_ZERO_REDIRECT_SUPPORTED = "is_zero_redirect_supported";
    String BIN_INFO_IS_OTP_ON_THE_FLY = "is_otp_on_the_fly";
    String BIN_INFO_IS_ATM_PIN_CARD = "is_atmpin_card";
    String SI_PAYMENT_SOURCE = "si_payment_source";
    String TPV_PAYMENT_SOURCE = "tpv_payment_source";
    String PAYU_WEALTH_TECH_PAYMENT_SOURCE = "wealth_tech_payment_source";
    String PAYU_MERCHANT_ACCESS_KEY = "merchantAccessKey";
    String PAYU_BASE_AMOUNT = "baseAmount";
    String PAYU_VALUE = "value";
    String PAYU_CURRENCY = "currency";
    String PAYU_CARD_BIN = "cardBin";
    String PAYU_MERCHANT_ORDER_ID = "merchantOrderId";
    String PAYU_PRODUCT_TYPE = "productType";
    String PAYU_SIGNATURE = "signature";
    String PAYU_GET_OFFER_DETAILS = "get_all_offer_details";
    String PAYU_VALIDATE_OFFER_DETAILS = "validate_offer_details";
    String PAYU_SIGNING_STRING = "signing_string";
    String PAYU_OFFER_AMOUNT = "offerAmount";
    String PAYU_OFFER_CURRENCY = "offerCurrency";
    String PAYU_OFFER_EXCHANGE_RATE = "offerExchangeRate";
    String PAYU_LOOK_UP_ID = "lookupId";

    String PAYU_RESULT_CODE = "resultCode";
    String PAYU_RESULT_MESSAGE = "resultMessage";
    String PAYU_RESULT_RESPONSE = "response";
    String PAYU_RESULT = "result";
    String PAYU_MESSAGE = "message";
    String PAYU_SUPPORTED_CARD_SCHEMES = "supportedCardSchemes";
    String PAYU_MCP_CONVERSION_BINS = "mcpConversionBeans";

    String REQUEST_APPLICATION_JSON = "application/json";
    String REQUEST_APPLICATION_URL_ENCODED = "application/x-www-form-urlencoded";
    String V2_API_TIME_FORMATE = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    //IFSC Details
    String IFSC_BANK = "bank";
    String IFSC_CITY = "city";
    String IFSC_KEY = "ifsc";
    String IFSC_MICR = "micr";
    String IFSC_STATE = "state";
    String IFSC_BRANCH = "branch";
    String IFSC_OFFICE = "office";
    String IFSC_ADDRESS = "address";
    String IFSC_CONTACT = "contact";
    String IFSC_DISTRICT = "district";

    String GET_TOKENISED_USER_CARD = "get_payment_instrument";
    String DELETE_TOKENISED_USER_CARD = "delete_payment_instrument";
    String GET_TOKENISED_CARD_DETAILS = "get_payment_details";
    String TOKENISED_CARD_DETAILS = "details";

    String TOKENISED_CARD_CRYPTOGRAM = "cryptogram";
    String TOKENISED_CARD_ISSUER_TOKEN = "issuer_token";
    String TOKENISED_CARD_NETWORK_TOKEN = "network_token";

    String TOKENISED_CARD_TOKEN_VALUE = "token_value";
    String TOKENISED_CARD_TOKEN_EXP_MON = "token_exp_mon";
    String TOKENISED_CARD_TOKEN_EXP_YR = "token_exp_yr";

    String TOKENISED_CARD_TRID = "trid";
    String TOKENISED_CARD_TOKEN_REFERENCE_ID = "token_refernce_id";
    String SDK_CONFIGURATION = "get_sdk_configuration";


    String DEPRECATED_DELETE_CARD_TASK_MESSAGE = "The \"DeleteCardTask\" is deprecated right now, please use \"DeleteTokenisedCardTask\" instead.";
    String DEPRECATED_GET_STORED_TASK_MESSAGE = "The \"GetStoredCardTask\" is deprecated right now, please use \"GetTokenisedCardTask\" instead.";
    String DEPRECATED_EDIT_CARD_TASK_MESSAGE = "The \"EditCardTask\" is not supported because of RBI guidelines, in order to save or edit the card, please save card by authenticating it doing an actual payment.";
    String DEPRECATED_SAVE_CARD_TASK_MESSAGE = "The \"SaveCardTask\" is not supported because of RBI guidelines, in order to save or edit the card, please save card by authenticating it doing an actual payment.";

    String IBIBOCODE = "ibiboCode";
    String PAYMENT_OPTION_ASSET_UPDATED_ON = "imageUpdatedOn";
    //TODO: rename to category post backend changes
    String PAYMENT_OPTION_CATEGORY = "category";
    String PAYMENT_OPTION_ASSET_URL = "imageURL";
    String UPI_SI_APPS = "apps";
    String UPI_SI_HANDLES = "handles";
    String P_PAYMENTCODE = "paymentCode";
    String P_CATEGORY = "category";
    String P_ISVALID = "isValid";
    String P_OFFER_DISCOUNT = "offerDiscount";
    String P_OFFERKEY = "offerKey";
    String P_OFFERTYPE = "offerType";
    String P_DISCOUNT = "discount";
    String P_DISCOUNTEDAMT = "discountedAmount";
    String P_DISCOUNTTYPE = "discountType";
    String P_OFFERDETAILS = "offerDetail";
    String P_TITLE = "title";
    String P_CODE = "code";
    String P_DESCRIPTION = "description";
    String P_VALIDFROM = "validFrom";
    String P_VALIDTO = "validTo";
    String P_TNC = "tnc";
    String P_TNCLINK = "tncLink";
    String P_OFFERPERCENTAGE = "offerPercentage";
    String P_MAX_DISCOUNT_PTXN = "maxDiscountPerTxn";
    String P_MINTXNAMT = "minTxnAmount";
    String P_MAXTXNAMT = "maxTxnAmount";
    String P_STATUS = "status";
    String P_ISNCE = "isNce";
    String P_DTXNINVALIDOFFER = "disallowTransactionInvalidOffer";
    String P_FAILUREREASON = "failureReason";
    String P_DISCOUNT_DETAILS = "discountDetail";
    String P_MAXDICOUNT = "maxDiscount";
    String P_DISCOUNT_PNT = "discountPercentage";
    String P_MID = "mid";
    String REQUEST_APPLICATION_CHAR_JSON = "application/json; charset=utf8";
    String MERCHANT_PARAM = "merchant_param";
    String P_NAME = "name";
    String P_IBIBOCODE = "ibiboCode";


    //keys for ADs
    String CP_ADS_PATH = "path";
    String CP_ASSETS_DETAILS = "assets";
    String PAYU_IS_ADS_ENABLE = "isAdsEnabled";
    String CP_ADS_REQUEST_ID = "requestId";
    String CP_ADS_EVENT = "event";
    String PAYU_SOURCE = "source";
    String PAYU_MERCHANT_KEY = "merchantKey";
    String CP_ADS_PAYUID = "payuId";

    //httpConnection Const
    String PAYU_METHOD = "method";
    String PAYU_URL = "URL";
    String PAYU_HEADER = "headers";
    String PAYU_POST_DATA = "postData";
    String PAYU_REQUEST_TYPE = "requestType";
    String PAYU_TIMEOUT = "timeout";
    String PAYU_CONTENT_TYPE = "Content-Type";
    String PAYU_CONTENT_LENGTH = "Content-Length";

    //HEADERS Global Vault
    String CLIENTTYPE_KEY = "clientType";
    String CLIENTTYPE_VALUE = "payu";
    String POST = "POST";
    String UUID = "uuid";

    //Global Vault
    String PAYU_HTTPSTATUSCODE = "httpStatusCode";
    String PAYU_RESPONSECODE = "responseCode";
    String PAYU_RESPONSEMESSAGE = "responseMessage";
    String PAYU_TOKEN = "token";
    String PAYU_QUICKPAYEVENT = "quickPayEvent";
    String MOBILE_NUMBER = "mobileNumber";
    String OTP = "otp";
    String DATE = "date";
    String DIGEST = "digest";
    String MID = "mid";
    String SOURCE = "source";
    String INTERNAL = "internal";
    String AUTHORIZATION = "authorization";
    String AUTH_HEADER_PARAM_1 = "hmac username=\"";
    String AUTH_HEADER_PARAM_2 = "\", algorithm=\"sha512\", headers=\"date\", signature=\"";
    String SIGNINGSTRING_DATE = "date: ";
    String SIGNINGSTRING_DIGEST = "\ndigest: ";

    String PAYU_IS_QUICKPAY_ENABLE = "isQuickPayEnabled";

    String PAYU_SAVEDOPTIONS = "savedPaymentOptions";
    String PAYU_BIN_BASE = "binBaseDetails";
    String PAYU_FETCH_CONV_F = "fetchConvFee";
    String PAYU_SEND_OTP = "sendOtp";
    String PAYU_SET_MPIN = "setMPin";
    String PAYU_FORGET_MPIN = "forgetMPin";
    String PAYU_VERIFY_MPIN = "verifyMapin";
    //Global Vault
    String GV_REQUESTID = "requestId";
    String GV_REQUESTTYPE = "requestType";
    String GV_USER_CREDENTIALS = "userCredentials";
    String GV_PAYMODE = "paymentMode";
    String PAYU_ACTION = "action";
    String GV_TAG = "tag";
    String GV_USER_INFO = "userInfo";
    String GV_PAYMENT_INFO = "paymentInfo";
    String GV_ELIGIBILITY_CHECK = "eligibilityCheck";
    String GV_ELIGIBILITY_AMOUNT = "eligibleAmount";
    String GV_TILES = "tiles";
    String GV_CASHCARD = "cashcard";

    String STRING_ZERO = "0";
    String WALLET_IDENTIFIER = "walletIdentifier";
    String PAYU_ENABLE_INTERNAL_3DSS = "enableInternal3DSS";
    String PAYU_INTERNATIONAL_ON_3DSS = "internationalOn3DSS";
    String PAYU_ENABLE_3DSSDK = "enable3dsSDK";
    String PAYU_3DS_SUPPORTED_BANK_LIST = "3DSSupportedBankList";

    String DEVICE_ID_API_ENDPOINT = "fems/sdk/v1/device-details";
    String CP_MIHPAYID = "mihpayid";
    String CHANNEL = "channel";
    String SDK = "SDK";
    String GAID = "gaId";
    String DEVICE_INFO = "deviceInfo";
    String DEVICE_FP = "deviceFP";
    String CP_HASH_STRING = "hashString";
    String CP_HASH_NAME = "hashName";
    String PAYU_CALCULATE_EMI = "calculate_emi_hash";

    String X_CREDENTIAL_USERNAME = "x-credential-username";

    String P_AUTO_APPLY = "autoApply";
    String P_TXN_AMOUNT = "txnAmount";
    String P_ADDITIONAL_CHARGE = "additionalCharges";

    String P_BANK_CODES = "bankCodes";
    String P_EMI_CODES = "emiCodes";
    String P_DISABLE_OVERRIDE_NCE_CONFIG = "disableOverrideNceConfig";

    String P_PAYMENT_DETAILS = "paymentDetail";
    String P_USER_DETAILS = "userDetail";

    String P_CARD_HASH = "cardHash";
    String P_CARD_MASK = "cardMask";
    String P_CARD_NUMBER = "cardNumber";
    String P_CARD_TOKEN = "cardToken";
    String P_CARD_TOKEN_TYPE = "cardTokenType";

    String P_OFFER_CATEGORY = "offerCategory";
    String P_TOTAL_DISCOUNT_DETAILS = "totalDiscountDetail";
    String P_TOTAL_CB_AMOUNT = "totalCashbackDiscount";
    String P_TOTAL_DISCOUNT_AMOUNT = "totalDiscountedAmount";
    String P_TOTAL_INSTANT_AMOUNT = "totalInstantDiscount";

    String P_IS_SKU_OFFER = "isSkuOffer";


    String SECURE_WEBVIEW = "secureWebview";
    String VERIFICATION_MODE = "verificationMode";

    String P_IS_NO_COST_EMI = "isNoCostEmi";

    String P_CARD_LESS = "cardLess";
    String P_IS_ALL_P_MODE = "isAllPaymentMethodsAvailable";
    String PAYU_IS_OFFER_ENABLED = "isOfferEnabled";
    String PAYU_UPI_APPS = "upiApps";
    String PAYU_APP_NAME = "appName";
    String PAYU_HANDLERS = "handlers";
    String PAYU_ANDROID_BUNDLE_IDENTIFIER = "androidBundleIdentifier";
    String PAYU_CUSTOMER_REVENUE_ENABLED = "customerRevenueEnabled";

    String PAYU_CONSENT = "consent";
    String GV_USER_CREDENTIAL = "userCredential";

    String PAYU_DELETE_SAVED_OPTIONS = "deleteSavedOptions";

    String PAYU_IS_QUICK_PAY_BT_SHEET_ENABLED = "isQuickPayBottomSheetEnabled";
    String PAYU_IS_NFC_ENABLED = "nfcEnabled";

    String PAYU_PHONE_NUMBER = "phoneNumber";

    String ASYNC_TASK_ILLEGAL_STATE_EXCEPTION_MESSAGE_1 = "Cannot execute task:"
            + " the task is already running.";

    String ASYNC_TASK_ILLEGAL_STATE_EXCEPTION_MESSAGE_2 = "Cannot execute task:"
            + " the task has already been executed "
            + "(a task can be executed only once)";
    String PAYU_GV_SEND_OTP = "send_sign_in_otp";
    String PAYU_GV_RESEND_OTP = "resend_sign_in_otp";
    String PAYU_GV_VERIFY_OTP = "verify_sign_in_otp";
    String PAYU_FETCH_IFSC_DETAILS = "fetch_IFSC";
    String PAYU_FETCH_DEVICE_ID = "fetch_device_id";

    String PAYU_IFSC_CODE_PARAM = "?ifscCode=";

    String PAYU_IFSC_BANK_NAME_MAPPING = "ifscBankNameMapping";

    String INSTANT = "INSTANT";
    String CASHBACK = "CASHBACK";
    String REWARD = "REWARD";
    String PAYU_PARAM_IS_USER_VERIFICATION_REQUIRED = "isUserVerificationRequired";
    String PAYU_PARAM_TO_DISPLAY = "toDisplay";
    String PAYU_PARAM_FIRST_NAME = "firstName";
    String PAYU_PARAM_COUPONS_AVAILABLE = "couponsAvailable";
    String PAYU_SOURCE_ANDROID_SDK = "Android_SDK";
    String PAYU_UPI_SI_APPS = "upiSiApps";
    String PAYU_ANT = "ANTPAY";

    String PAYU_OPGSP_MERCHANT = "opgsp_merchant";

    String PAYU_IS_INSURANCE_MERCHANT = "isInsuranceMerchant";
}
