package com.payu.india.Model.adsinformation;

import android.util.Log;

import com.payu.india.Payu.PayuConstants;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONException;
import org.json.JSONObject;

public class AdsImpressionApiRequest extends V2ApiBase {
    private String event;
    private String requestID;

    private AdsImpressionApiRequest(Builder builder) {
        this.event = builder.event;
        this.requestID = builder.requestID;
    }

    @Override
    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PayuConstants.CP_ADS_EVENT, event);
            jsonObject.put(PayuConstants.CP_ADS_REQUEST_ID, requestID);
        } catch (JSONException e) {
            Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private String event;
        private String requestID;

        public Builder setEvent(String event) {
            this.event = event;
            return this;
        }

        public Builder setRequestId(String requestID) {
            this.requestID = requestID;
            return this;
        }

        public AdsImpressionApiRequest build() {
            return new AdsImpressionApiRequest(this);
        }
    }


}

