package com.payu.india.Model.QuickPay;

import android.util.Log;

import com.payu.india.Payu.PayuConstants;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Purpose of the class to perform construction of the Request Params for Send OTP and Resend OTP
 */
public class GlobalVaultOTPRequest extends V2ApiBase {

    /* Mobile number */
    private final String mobileNumber;

    private GlobalVaultOTPRequest(Builder builder) {
        this.mobileNumber = builder.mobileNumber;
    }

    @Override
    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PayuConstants.MOBILE_NUMBER, mobileNumber);
        } catch (JSONException e) {
            Log.d("GlobalVaultOTPRequest", "Exception " + e.getMessage());
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private String mobileNumber;

        public Builder setMobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        public GlobalVaultOTPRequest build() {
            return new GlobalVaultOTPRequest(this);
        }
    }
}
