package com.payu.india.Model.Olw;

import android.util.Log;

import com.payu.india.Payu.PayuConstants;
import com.payu.paymentparamhelper.EncryptionUtils;
import com.payu.paymentparamhelper.SetMPinEncryptedInfo;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONObject;

public class SetMPinRequest extends V2ApiBase {
    private final String newMpin;
    private final String action;
    private final String otp;
    private final String deviceId;
    private final SendOtpRequest sendOtpRequest;

    // Private constructor that takes a builder
    private SetMPinRequest(Builder builder) {
        this.newMpin = builder.newMpin;
        this.action = builder.action;
        this.otp = builder.otp;
        this.deviceId = builder.deviceId;
        this.sendOtpRequest = builder.sendOtpRequest;
    }

    @Override
    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PayuConstants.PAYU_CLIENT_TXN_ID, sendOtpRequest.getClientTxnId());
            jsonObject.put(PayuConstants.PAYU_REQUEST_DATE_TIME, sendOtpRequest.getRequestDateTime());
            jsonObject.put(PayuConstants.PAYU_ACTION, action);
            SetMPinEncryptedInfo setMPinEncryptedInfo = EncryptionUtils.encrypt(otp, newMpin, PayuConstants.PayuLoyalityConstant.subPart1 + PayuConstants.PayuLoyalityConstant.subPart2 + PayuConstants.PayuLoyalityConstant.subPart3);
            String encryptedOtp = setMPinEncryptedInfo.getOtp();
            String encryptedMPin = setMPinEncryptedInfo.getmPin();
            String encryptedAesKey = setMPinEncryptedInfo.getEncryptedAesKey();
            jsonObject.put(PayuConstants.OTP, encryptedOtp);
            jsonObject.put(PayuConstants.PAYU_NEW_MPIN, encryptedMPin);
            jsonObject.put(PayuConstants.KEY, encryptedAesKey);
            jsonObject.put(PayuConstants.PAYU_CUSTOMER_MOBILE, sendOtpRequest.getCustomerMobile());
            jsonObject.put(PayuConstants.PAYU_DEVICE_ID, deviceId);
        } catch (Exception e) {
            Log.d("SetMPinRequest", "Exception " + e.getMessage());
        }
        return jsonObject.toString();
    }

    // Static Builder class
    public static class Builder {
        private String newMpin;
        private String action;
        private String otp;
        private String deviceId;
        private SendOtpRequest sendOtpRequest;

        // Builder methods for setting properties (returns the Builder for chaining)
        public Builder setNewMpin(String newMpin) {
            this.newMpin = newMpin;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setOtp(String otp) {
            this.otp = otp;
            return this;
        }

        public Builder setDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder setSendOtpRequest(SendOtpRequest sendOtpRequest) {
            this.sendOtpRequest = sendOtpRequest;
            return this;
        }

        // Build method to create the SetMPinRequest object
        public SetMPinRequest build() {
            return new SetMPinRequest(this);
        }
    }


}
