package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;

public class MerchantParamInfo implements Parcelable {
    private boolean isAdsEnabled;
    private boolean isQuickPayEnabled;
    private boolean enableInternal3DSS;
    private boolean internationalOn3DSS;
    private boolean enable3dsSDK;
    private ArrayList<String> threedsBankList;
    private boolean isDeviceIdEnabled;
    private boolean isOfferEnabled;
    private boolean isQuickPayBottomSheetEnabled;
    private boolean nfcEnabled;
    private ArrayList<UpiApp> upiApps;
    private ArrayList<String> upiSIApps;
    private boolean isOpgspMerchant;


    public ArrayList<UpiApp> getUpiApps() {
        return upiApps;
    }

    public boolean customerRevenueEnabled;

    public boolean isInsuranceMerchant;

    public void setUpiApps(ArrayList<UpiApp> upiApps) {
        this.upiApps = upiApps;
    }

    public boolean isAdsEnabled() {
        return isAdsEnabled;
    }

    public void setAdsEnabled(boolean adsEnabled) {
        isAdsEnabled = adsEnabled;
    }

    public boolean isQuickPayEnabled() {
        return isQuickPayEnabled;
    }

    public void setQuickPayEnabled(boolean quickPayEnabled) {
        isQuickPayEnabled = quickPayEnabled;
    }

    public boolean isEnableInternal3DSS() {
        return enableInternal3DSS;
    }

    public void setEnableInternal3DSS(boolean enableInternal3DSS) {
        this.enableInternal3DSS = enableInternal3DSS;
    }

    public boolean isInternationalOn3DSS() {
        return internationalOn3DSS;
    }

    public void setInternationalOn3DSS(boolean internationalOn3DSS) {
        this.internationalOn3DSS = internationalOn3DSS;
    }

    public boolean isEnable3dsSDK() {
        return enable3dsSDK;
    }

    public void setEnable3dsSDK(boolean enable3dsSDK) {
        this.enable3dsSDK = enable3dsSDK;
    }

    public ArrayList<String> getThreedsBankList() {
        return threedsBankList;
    }

    public void setThreedsBankList(ArrayList<String> threedsBankList) {
        this.threedsBankList = threedsBankList;
    }

    public boolean isDeviceIdEnabled() {
        return isDeviceIdEnabled;
    }

    public void setDeviceIdEnabled(boolean deviceIdEnabled) {
        isDeviceIdEnabled = deviceIdEnabled;
    }

    public boolean isOfferEnabled() {
        return isOfferEnabled;
    }

    public void setOfferEnabled(boolean offerEnabled) {
        isOfferEnabled = offerEnabled;
    }

    public boolean isQuickPayBottomSheetEnabled() {
        return isQuickPayBottomSheetEnabled;
    }

    public void setQuickPayBottomSheetEnabled(boolean quickPayBottomSheetEnabled) {
        isQuickPayBottomSheetEnabled = quickPayBottomSheetEnabled;
    }

    public boolean isNfcEnabled() {
        return nfcEnabled;
    }

    public void setNfcEnabled(boolean nfcEnabled) {
        this.nfcEnabled = nfcEnabled;
    }

    public boolean isCustomerRevenueEnabled() {
        return customerRevenueEnabled;
    }

    public void setCustomerRevenueEnabled(boolean customerRevenueEnabled) {
        this.customerRevenueEnabled = customerRevenueEnabled;
    }

    public ArrayList<String> getUpiSIApps() {
        return upiSIApps;
    }

    public void setUpiSIApps(ArrayList<String> upiSIApps) {
        this.upiSIApps = upiSIApps;
    }

    public boolean isOpgspMerchant() {
        return isOpgspMerchant;
    }

    public void setOpgspMerchant(boolean opgspMerchant) {
        this.isOpgspMerchant = opgspMerchant;
    }

    public boolean isInsuranceMerchant() {
        return isInsuranceMerchant;
    }

    public void setInsuranceMerchant(boolean insuranceMerchant) {
        isInsuranceMerchant = insuranceMerchant;
    }

    public MerchantParamInfo() {
    }

    protected MerchantParamInfo(Parcel in) {
        isAdsEnabled = in.readByte() != 0;
        isQuickPayEnabled = in.readByte() != 0;
        enableInternal3DSS = in.readByte() != 0;
        internationalOn3DSS = in.readByte() != 0;
        enable3dsSDK = in.readByte() != 0;
        threedsBankList = in.createStringArrayList();
        isDeviceIdEnabled = in.readByte() != 0;
        isOfferEnabled = in.readByte() != 0;
        isQuickPayBottomSheetEnabled = in.readByte() != 0;
        nfcEnabled = in.readByte() != 0;
        customerRevenueEnabled = in.readByte() != 0;
        upiApps = in.createTypedArrayList(UpiApp.CREATOR);
        upiSIApps = in.createStringArrayList();
        isOpgspMerchant = in.readByte() != 0;
        isInsuranceMerchant = in.readByte() != 0;
    }

    public static final Creator<MerchantParamInfo> CREATOR = new Creator<MerchantParamInfo>() {
        @Override
        public MerchantParamInfo createFromParcel(Parcel in) {
            return new MerchantParamInfo(in);
        }

        @Override
        public MerchantParamInfo[] newArray(int size) {
            return new MerchantParamInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeByte((byte) (isAdsEnabled ? 1 : 0));
        parcel.writeByte((byte) (isQuickPayEnabled ? 1 : 0));
        parcel.writeByte((byte) (enableInternal3DSS ? 1 : 0));
        parcel.writeByte((byte) (internationalOn3DSS ? 1 : 0));
        parcel.writeByte((byte) (enable3dsSDK ? 1 : 0));
        parcel.writeStringList(threedsBankList);
        parcel.writeByte((byte) (isDeviceIdEnabled ? 1 : 0));
        parcel.writeByte((byte) (isOfferEnabled ? 1 : 0));
        parcel.writeByte((byte) (isQuickPayBottomSheetEnabled ? 1 : 0));
        parcel.writeByte((byte) (nfcEnabled ? 1 : 0));
        parcel.writeByte((byte) (customerRevenueEnabled ? 1 : 0));
        parcel.writeTypedList(upiApps);
        parcel.writeStringList(upiSIApps);
        parcel.writeByte((byte) (isOpgspMerchant ? 1 : 0));
        parcel.writeByte((byte) (isInsuranceMerchant ? 1 : 0));
    }
}
