package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

public class FetchOfferInfo extends OfferInformation implements Parcelable {

    private String type;

    private boolean isSkuOffer;

    private boolean isAllPayModeOffer;

    public FetchOfferInfo() {
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isSkuOffer() {
        return isSkuOffer;
    }

    public void setSkuOffer(boolean skuOffer) {
        isSkuOffer = skuOffer;
    }

    public boolean isAllPayModeOffer() {
        return isAllPayModeOffer;
    }

    public void setAllPayModeOffer(boolean allPayModeOffer) {
        isAllPayModeOffer = allPayModeOffer;
    }

    protected FetchOfferInfo(Parcel in) {
        super(in);
        type = in.readString();
        isSkuOffer = in.readByte() != 0;
        isAllPayModeOffer = in.readByte() != 0;
    }

    public static final Creator<FetchOfferInfo> CREATOR = new Creator<FetchOfferInfo>() {
        @Override
        public FetchOfferInfo createFromParcel(Parcel in) {
            return new FetchOfferInfo(in);
        }

        @Override
        public FetchOfferInfo[] newArray(int size) {
            return new FetchOfferInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(type);
        parcel.writeByte((byte) (isSkuOffer ? 1 : 0));
        parcel.writeByte((byte) (isAllPayModeOffer ? 1 : 0));
    }
}
