package com.payu.india.Model;

import android.util.Log;

import com.payu.paymentparamhelper.V2ApiBase;
import com.payu.india.Payu.PayuConstants;

import org.json.JSONException;
import org.json.JSONObject;

public class DeviceIdRequest extends V2ApiBase {
    private String payUID;
    private String gaID;

    private DeviceIdRequest(Builder builder) {
        this.payUID = builder.payUID;
        this.gaID = builder.gaID;
    }

    @Override
    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        JSONObject deviceInfoJson = new JSONObject();
        try {
            jsonObject.put(PayuConstants.CP_MIHPAYID, payUID);
            jsonObject.put(PayuConstants.CHANNEL, PayuConstants.SDK);
            deviceInfoJson.put(PayuConstants.GAID, gaID);
            jsonObject.put(PayuConstants.DEVICE_INFO, deviceInfoJson);
        } catch (JSONException e) {
            Log.v("DeviceIdRequest", e.getMessage());
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private String payUID;
        private String gaID;

        public Builder setPayUID(String payUID) {
            this.payUID = payUID;
            return this;
        }

        public Builder setGaid(String gaID) {
            this.gaID = gaID;
            return this;
        }

        public DeviceIdRequest build() {
            return new DeviceIdRequest(this);
        }
    }
}