//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by franklin on 7/1/15.
 * Simple bean implementation of card information
 * When the app uses {@link com.payu.india.Tasks.GetCardInformationTask} the response will be passed as {@link CardInformation}
 * along with the {@link PostData} in {@link PayuResponse}
 */
public class CardInformation implements Parcelable {

    private Boolean isDomestic; // Domestic / international
    private String issuingBank; // Name of the issuing bank
    private String cardCategory; // Card category (VISA, MAST, etc)
    private String cardType; // Card type (CC, DC)
    private Boolean isSiSupported;
    private String bin;
    private Boolean isZeroRedirectSupported;
    private Boolean isOtpOnTheFly;
    private Boolean isAtmPinCard;
    private String pgId;
    private String convenienceFee;
    private String gst;
    private String bankCode;
    private boolean binLevel;

    public CardInformation() {
    }


    public Boolean getIsSiSupported() {
        return isSiSupported;
    }

    public void setIsSiSupported(Boolean isSiSupported) {
        this.isSiSupported = isSiSupported;
    }

    public String getBin() {
        return bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    protected CardInformation(Parcel in) {
        issuingBank = in.readString();
        cardCategory = in.readString();
        cardType = in.readString();
        bin = in.readString();
        pgId = in.readString();
        isSiSupported = in.readByte() != 0;
        isZeroRedirectSupported = in.readByte() != 0;
        isOtpOnTheFly = in.readByte() != 0;
        isAtmPinCard = in.readByte() != 0;
        convenienceFee = in.readString();
        gst = in.readString();
        bankCode = in.readString();
        binLevel = in.readByte() != 0;
    }

    public static final Creator<CardInformation> CREATOR = new Creator<CardInformation>() {
        @Override
        public CardInformation createFromParcel(Parcel in) {
            return new CardInformation(in);
        }

        @Override
        public CardInformation[] newArray(int size) {
            return new CardInformation[size];
        }
    };

    public String getIssuingBank() {
        return issuingBank;
    }

    public void setIssuingBank(String issuingBank) {
        this.issuingBank = issuingBank;
    }

    public Boolean getIsDomestic() {
        return isDomestic;
    }

    public void setIsDomestic(Boolean isDomestic) {
        this.isDomestic = isDomestic;
    }

    public String getCardCategory() {
        return cardCategory;
    }

    public void setCardCategory(String cardCategory) {
        this.cardCategory = cardCategory;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(issuingBank);
        dest.writeString(cardCategory);
        dest.writeString(cardType);
        dest.writeString(bin);
        dest.writeString(pgId);
        dest.writeByte((byte) (isSiSupported ? 1 : 0));
        dest.writeByte((byte) (isZeroRedirectSupported ? 1 : 0));
        dest.writeByte((byte) (isOtpOnTheFly ? 1 : 0));
        dest.writeByte((byte) (isAtmPinCard ? 1 : 0));
        dest.writeString(convenienceFee);
        dest.writeString(gst);
        dest.writeString(bankCode);
        dest.writeByte((byte) (binLevel ? 1 : 0));
    }


    public Boolean getIsZeroRedirectSupported() {
        return isZeroRedirectSupported;
    }

    public void setIsZeroRedirectSupported(Boolean zeroRedirectSupported) {
        isZeroRedirectSupported = zeroRedirectSupported;
    }

    public Boolean getIsOtpOnTheFly() {
        return isOtpOnTheFly;
    }

    public void setIsOtpOnTheFly(Boolean otpOnTheFly) {
        isOtpOnTheFly = otpOnTheFly;
    }

    public Boolean getIsAtmPinCard() {
        return isAtmPinCard;
    }

    public void setIsAtmPinCard(Boolean atmPinCard) {
        isAtmPinCard = atmPinCard;
    }

    public String getPgId() {
        return pgId;
    }

    public void setPgId(String pgId) {
        this.pgId = pgId;
    }

    public String getConvenienceFee() {
        return convenienceFee;
    }

    public void setConvenienceFee(String convenienceFee) {
        this.convenienceFee = convenienceFee;
    }

    public String getGst() {
        return gst;
    }

    public void setGst(String gst) {
        this.gst = gst;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public boolean isBinLevel() {
        return binLevel;
    }

    public void setBinLevel(boolean binLevel) {
        this.binLevel = binLevel;
    }
}
