package com.payu.india.Tasks;

import android.util.Log;

import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

public class UpdatePayUIdTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PostData postData = new PostData();
        PayuResponse payuResponse = new PayuResponse();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_APIV2_URL);
                    break;
                default:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.PUT).
                    setURL(url + PayuConstants.ADS_UPDATE_PAYUID_API_ENDPOINT).setPostData(payuConfig.getData()).
                    setRequestType(PayuConstants.REQUEST_APPLICATION_CHAR_JSON).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);

                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has(PayuConstants.STATUS) && response.getBoolean(PayuConstants.STATUS)) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                } else {
                    postData.setResult(PayuErrors.ERROR_SAVE_PAYU_ID);
                    postData.setStatus(PayuConstants.ERROR);
                }
            }
        } catch (IOException | JSONException e) {
            Log.d(getClass().getSimpleName(), "Exception " + e.getMessage());
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;


    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
    }
}

