//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Tasks;

import android.util.Log;

import com.payu.india.Interfaces.GetEmiAmountAccordingToInterestApiListener;
import com.payu.india.Interfaces.GetOfferStatusApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuEmiAmountAccordingToInterest;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;

import javax.net.ssl.HttpsURLConnection;

/**
 * Created by franklin on 7/3/15.
 * Async task which takes care of getting offer status
 * Takes PayuConfig as input and sends PayuResponse to the calling activity
 * Activity which calls {@link GetEmiAmountAccordingToInterestTask } should implement {@link GetOfferStatusApiListener}
 */
public class GetEmiAmountAccordingToInterestTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private  final String TAG = getClass().getSimpleName();

    GetEmiAmountAccordingToInterestApiListener apiListener;

    public GetEmiAmountAccordingToInterestTask(GetEmiAmountAccordingToInterestApiListener apiListener) {
        this.apiListener = apiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }


            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);

                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(jsonResponse);
                if (jsonResponse.has(PayuConstants.MSG)) {
                    postData.setResult(jsonResponse.getString(PayuConstants.MSG));
                }
                if (jsonResponse.has(PayuConstants.STATUS) && jsonResponse.getInt(PayuConstants.STATUS) == 0) {
                    postData.setCode(PayuErrors.INVALID_HASH);
                    postData.setStatus(PayuConstants.ERROR);
                } else {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                }

                Iterator<String> keys = jsonResponse.keys();
                HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>> emiResponse = new HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>>();

                while (keys.hasNext()) {

                    String bankCode = keys.next().toString();
                    JSONObject bankBasedResponse = new JSONObject(jsonResponse.getString(bankCode));

                    // Now iterate through bank response code and get the bean for each EMI
                    Iterator<String> nestedKeys = bankBasedResponse.keys();


                    HashMap<String, PayuEmiAmountAccordingToInterest> emiResponsePerEMIMonthBasis = new HashMap<String, PayuEmiAmountAccordingToInterest>();
                    while (nestedKeys.hasNext()) {
                        String emiMonth = nestedKeys.next().toString();

                        JSONObject emiBasedResponse = new JSONObject(bankBasedResponse.getString(emiMonth));

                        // EmiAmountAccordingToInterest Bean
                        PayuEmiAmountAccordingToInterest payuEmiAmountAccordingToInterest = new PayuEmiAmountAccordingToInterest();
                        // Populate the bean
                        payuEmiAmountAccordingToInterest.setEmiBankInterest(emiBasedResponse.optString(PayuConstants.EMI_BANK_INTEREST));
                        payuEmiAmountAccordingToInterest.setBankRate(emiBasedResponse.optString(PayuConstants.BANK_RATE));
                        payuEmiAmountAccordingToInterest.setBankCharge(emiBasedResponse.optString(PayuConstants.BANK_CHARGE));
                        payuEmiAmountAccordingToInterest.setAmount(emiBasedResponse.optString(PayuConstants.AMOUNT));
                        payuEmiAmountAccordingToInterest.setCardType(emiBasedResponse.optString(PayuConstants.CARD_TYPE));
                        payuEmiAmountAccordingToInterest.setEmiValue(emiBasedResponse.optString(PayuConstants.EMI_VALUE));
                        payuEmiAmountAccordingToInterest.setEmiInterestPaid(emiBasedResponse.optString(PayuConstants.EMI_INTEREST_PAID));
                        payuEmiAmountAccordingToInterest.setTenure(emiBasedResponse.optString(PayuConstants.EMI_TENURE));

                        emiResponsePerEMIMonthBasis.put(emiMonth, payuEmiAmountAccordingToInterest);
                    }

                    emiResponse.put(bankCode, emiResponsePerEMIMonthBasis);
                }

                // Set Map<BankCode, EMIDetails> here
                payuResponse.setPayuEmiAmountAccordingToInterest(emiResponse);
            }
        } catch (MalformedURLException e) {
            Log.d(TAG, "MalformedURLException " + e.getMessage());
        } catch (ProtocolException e) {
            Log.d(TAG, "ProtocolException " + e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, "IOException " + e.getMessage());
        } catch (JSONException e) {
            Log.d(TAG, "JSONException " + e.getMessage());
        }

        // gotta return payuResponse
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        apiListener.onGetEmiAmountAccordingToInterestApiResponse(payuResponse);
    }
}
