package com.payu.india.Payu.v2ApiResponseParser;

import static com.payu.india.Payu.PayuConstants.DEBITCARD;
import static com.payu.india.Payu.PayuConstants.PAYU_IBIBOCODE;
import static com.payu.paymentparamhelper.PayuConstants.BINS_DATA;
import static com.payu.paymentparamhelper.PayuConstants.BIN_LEVEL;
import static com.payu.paymentparamhelper.PayuConstants.CC;
import static com.payu.paymentparamhelper.PayuConstants.CONVENIENCE_FEE;
import static com.payu.paymentparamhelper.PayuConstants.CONVENIENCE_FEE_DATA;
import static com.payu.paymentparamhelper.PayuConstants.DATA;
import static com.payu.paymentparamhelper.PayuConstants.DC;
import static com.payu.paymentparamhelper.PayuConstants.GST;
import static com.payu.paymentparamhelper.PayuConstants.PAYU_ONE;
import static com.payu.paymentparamhelper.PayuConstants.PAYU_ZERO;

import android.util.Log;

import com.payu.india.Model.ApiResponse;
import com.payu.india.Model.CardInformation;
import com.payu.india.Model.DiscountDetailsofOffers;
import com.payu.india.Model.ValidateOfferInfo;
import com.payu.india.Model.fetchConvenienceFee.Charges;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeCombinations;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeResponse;
import com.payu.india.Model.validateOffer.SKUOfferDetails;
import com.payu.india.Model.validateOffer.ValidateOfferDetails;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuUtils;
import com.payu.paymentparamhelper.Sku;
import com.payu.paymentparamhelper.SkuDiscountDetails;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class V2ApiResponseParser {


    public void parseBinInfoResponse(JSONObject jsonResponse, CardInformation cardInformation) throws JSONException {
        JSONObject binsData = jsonResponse.getJSONObject(BINS_DATA);
        JSONObject convFeeData = binsData.optJSONObject(CONVENIENCE_FEE_DATA);

        cardInformation.setIssuingBank(binsData.getString(PayuConstants.BIN_INFO_ISSUING_BANK));
        cardInformation.setBin(binsData.getString(PayuConstants.BIN_INFO_BIN_VALUE));
        cardInformation.setCardCategory(binsData.getString(PayuConstants.BIN_INFO_CARD_CATEGORY).equalsIgnoreCase(DEBITCARD) ? DC : CC);
        cardInformation.setCardType(binsData.getString(PayuConstants.BIN_INFO_CARD_TYPE));

        cardInformation.setIsZeroRedirectSupported(binsData.optInt(PayuConstants.BIN_INFO_IS_ZERO_REDIRECT_SUPPORTED) == 1);
        cardInformation.setIsOtpOnTheFly(binsData.optInt(PayuConstants.BIN_INFO_IS_OTP_ON_THE_FLY) == 1);
        cardInformation.setIsAtmPinCard(binsData.optString(PayuConstants.BIN_INFO_IS_ATM_PIN_CARD).contentEquals(PAYU_ONE));


        cardInformation.setIsSiSupported(binsData.optInt(PayuConstants.BIN_INFO_IS_SI_SUPPORTED) == 1);
        cardInformation.setPgId(binsData.optString(PayuConstants.PG_ID));
        cardInformation.setBankCode(binsData.optString(PAYU_IBIBOCODE));
        cardInformation.setIsDomestic(binsData.getString(PayuConstants.BIN_INFO_IS_DOMESTIC).contentEquals(PAYU_ONE));
        if (convFeeData != null) {
            cardInformation.setConvenienceFee(convFeeData.optString(CONVENIENCE_FEE, PAYU_ZERO));
            cardInformation.setGst(convFeeData.optString(GST, PAYU_ZERO));
            cardInformation.setBinLevel(convFeeData.optBoolean(BIN_LEVEL));
        }
    }

    public void parseValidateOfferResponse(JSONObject result, ValidateOfferDetails validateOfferDetails) throws JSONException {
        validateOfferDetails.setAmount(PayuUtils.getDoubleValue(result, PayuConstants.AMOUNT));
        validateOfferDetails.setValid(result.optBoolean(PayuConstants.P_ISVALID));
        if (!result.isNull(PayuConstants.P_TOTAL_DISCOUNT_DETAILS)) {
            JSONObject totalDiscountDetail = result.getJSONObject(PayuConstants.P_TOTAL_DISCOUNT_DETAILS);
            validateOfferDetails.setTotalCashbackDiscount(PayuUtils.getDoubleValue(totalDiscountDetail, PayuConstants.P_TOTAL_CB_AMOUNT));
            validateOfferDetails.setTotalInstantDiscount(PayuUtils.getDoubleValue(totalDiscountDetail, PayuConstants.P_TOTAL_INSTANT_AMOUNT));
            validateOfferDetails.setTotalDiscountedAmount(PayuUtils.getDoubleValue(totalDiscountDetail, PayuConstants.P_TOTAL_DISCOUNT_AMOUNT));
        }
            JSONArray offerDetailJsonArray = result.optJSONArray(PayuConstants.OFFERS);
            if (offerDetailJsonArray != null)
                validateOfferDetails.setValidateOfferInfo(prepareOfferInfoList(offerDetailJsonArray));

        validateOfferDetails.setFailureReason(PayuUtils.getStringValue(result, PayuConstants.P_FAILUREREASON));
        if (result.optJSONObject(PayuConstants.PAYU_SKUS_DETAILS) != null) {
            JSONObject skuDetails = result.optJSONObject(PayuConstants.PAYU_SKUS_DETAILS);
            JSONObject skuDiscountDetailsJson = skuDetails.optJSONObject(PayuConstants.P_SKU_DISCOUNT_DETAILS);

            validateOfferDetails.setTotalCashbackDiscount(PayuUtils.getDoubleValue(skuDiscountDetailsJson, PayuConstants.P_TOTAL_CB_AMOUNT));
            validateOfferDetails.setTotalInstantDiscount(PayuUtils.getDoubleValue(skuDiscountDetailsJson, PayuConstants.P_TOTAL_INSTANT_AMOUNT));
            validateOfferDetails.setTotalDiscountedAmount(PayuUtils.getDoubleValue(skuDiscountDetailsJson, PayuConstants.P_TOTAL_DISCOUNT_AMOUNT));
            if (skuDetails.optJSONArray(PayuConstants.P_SKUS) != null) {
                List<SKUOfferDetails> skuOfferDetailsList = new ArrayList<>();
                JSONArray skus = skuDetails.optJSONArray(PayuConstants.P_SKUS);
                for (int i = 0; skus != null && i < skus.length(); i++) {
                    JSONObject skuJsonObject = skus.optJSONObject(i);
                    Sku sku = new Sku();
                    sku.setSkuId(skuJsonObject.optString(PayuConstants.P_SKU_ID));
                    sku.setQuantity(skuJsonObject.optInt(PayuConstants.P_QUANTITY));
                    sku.setSkuAmount(skuJsonObject.optString(PayuConstants.P_SKU_AMOUNT));
                    sku.setName(skuJsonObject.optString(PayuConstants.NAME_KEY));
                    sku.setAutoApplyOffer(skuJsonObject.optBoolean(PayuConstants.P_AUTO_APPLY));

                    SKUOfferDetails skuOfferDetails = new SKUOfferDetails();
                    JSONObject totalSkuDiscountDetails = skuJsonObject.optJSONObject(PayuConstants.P_SKU_T_DISCOUNT_DETAILS);
                    if (totalSkuDiscountDetails != null) {
                        SkuDiscountDetails skuDiscountDetails = new SkuDiscountDetails();
                        skuDiscountDetails.setInstant(PayuUtils.getDoubleValue(totalSkuDiscountDetails, PayuConstants.P_TOTAL_INSTANT_AMOUNT));
                        skuDiscountDetails.setCashBack(PayuUtils.getDoubleValue(totalSkuDiscountDetails, PayuConstants.P_TOTAL_CB_AMOUNT));
                        skuDiscountDetails.setDiscountedAmount(PayuUtils.getDoubleValue(totalSkuDiscountDetails, PayuConstants.P_TOTAL_DISCOUNT_AMOUNT));
                        skuOfferDetails.setSkuDiscountDetails(skuDiscountDetails);
                    }
                    skuOfferDetails.setSku(sku);
                    skuOfferDetails.setValid(skuJsonObject.optBoolean(PayuConstants.P_ISVALID));
                    if (skuJsonObject.optJSONArray(PayuConstants.OFFERS) != null) {
                        JSONArray skuJofferDetailJsonArray = skuJsonObject.optJSONArray(PayuConstants.OFFERS);
                        if (skuJofferDetailJsonArray != null)
                            skuOfferDetails.setValidateOfferInfoList(prepareOfferInfoList(skuJofferDetailJsonArray));
                        skuOfferDetailsList.add(skuOfferDetails);
                    }
                }
                validateOfferDetails.setSkuOfferDetailsList(skuOfferDetailsList);
            }
        }
        validateOfferDetails.setAutoApply(result.optBoolean(PayuConstants.P_AUTO_APPLY));
    }

    private List<ValidateOfferInfo> prepareOfferInfoList(JSONArray offerDetailJsonArray) {
        List<ValidateOfferInfo> validateOfferInfoList = new ArrayList<>();
        for (int i = 0; i < offerDetailJsonArray.length(); i++) {
            try {
               JSONObject offerDetailJson = offerDetailJsonArray.getJSONObject(i);
                validateOfferInfoList.add(prepareValidateOfferInfo(offerDetailJson));
            } catch (JSONException e) {
                Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
            }
        }
        return validateOfferInfoList;
    }

    private ValidateOfferInfo prepareValidateOfferInfo(JSONObject validateInfoJsonObject) {
        ValidateOfferInfo validateOfferInfo = new ValidateOfferInfo();
        validateOfferInfo.setOfferKey(validateInfoJsonObject.optString(PayuConstants.F_OFFER_KEY));
        String offerType = validateInfoJsonObject.optString(PayuConstants.P_OFFERTYPE);
        validateOfferInfo.setOfferType(offerType);
        validateOfferInfo.setTitle(validateInfoJsonObject.optString(PayuConstants.TITLE));
        validateOfferInfo.setDescription(validateInfoJsonObject.optString(PayuConstants.DESCRIPTION));
        validateOfferInfo.setValidFrom(validateInfoJsonObject.optString(PayuConstants.P_VALIDFROM));
        validateOfferInfo.setValidTo(validateInfoJsonObject.optString(PayuConstants.P_VALIDTO));
        validateOfferInfo.setTnc(validateInfoJsonObject.optString(PayuConstants.P_TNC));
        validateOfferInfo.setTncLink(validateInfoJsonObject.optString(PayuConstants.P_TNCLINK));
        validateOfferInfo.setDiscountType(validateInfoJsonObject.optString(PayuConstants.P_DISCOUNTTYPE));
        validateOfferInfo.setOfferPercentage(validateInfoJsonObject.optString(PayuConstants.P_OFFERPERCENTAGE));
        validateOfferInfo.setMaxDiscountPerTxn(validateInfoJsonObject.optDouble(PayuConstants.P_MAX_DISCOUNT_PTXN));
        validateOfferInfo.setMaxTxnAmount(Double.parseDouble(Objects.requireNonNull(validateInfoJsonObject.opt(PayuConstants.P_MAXTXNAMT)).toString()));
        validateOfferInfo.setMinTxnAmount(Double.parseDouble(Objects.requireNonNull(validateInfoJsonObject.opt(PayuConstants.P_MINTXNAMT)).toString()));
        validateOfferInfo.setStatus(validateInfoJsonObject.optString(PayuConstants.STATUS));
        validateOfferInfo.setIsNoCostEmi(validateInfoJsonObject.optBoolean(PayuConstants.P_ISNCE));
        validateOfferInfo.setValid(validateInfoJsonObject.optBoolean(PayuConstants.P_ISVALID));
        validateOfferInfo.setOfferCategory(validateInfoJsonObject.optString(PayuConstants.P_OFFER_CATEGORY));
        validateOfferInfo.setSkuOffer(validateInfoJsonObject.optBoolean(PayuConstants.P_IS_SKU_OFFER));
        validateOfferInfo.setAllPaymentMethodsAvailable(validateInfoJsonObject.optBoolean(PayuConstants.P_IS_ALL_P_MODE));
        validateOfferInfo.setDisallowTransactionInvalidOffer(validateInfoJsonObject.optBoolean(PayuConstants.P_DTXNINVALIDOFFER));
        validateOfferInfo.setAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, PayuConstants.AMOUNT));
        validateOfferInfo.setDiscount(PayuUtils.getDoubleValue(validateInfoJsonObject, PayuConstants.DISCOUNT));
        validateOfferInfo.setDiscountedAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, PayuConstants.P_DISCOUNTEDAMT));
        DiscountDetailsofOffers discountDetailsofOffers = new DiscountDetailsofOffers();
        discountDetailsofOffers.setDiscount(PayuUtils.getDoubleValue(validateInfoJsonObject, PayuConstants.DISCOUNT));
        discountDetailsofOffers.setDiscountType(offerType);
        discountDetailsofOffers.setDiscountedAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, PayuConstants.P_DISCOUNTEDAMT));
        validateOfferInfo.setDiscountDetails(discountDetailsofOffers);
        return validateOfferInfo;
    }

    public void parseFetchConvFeeResponse(JSONObject jsonObject, ApiResponse<FetchConvFeeResponse> apiResponse) {
        JSONObject data = jsonObject.optJSONObject(DATA);
        FetchConvFeeResponse fetchConvFeeResponse = new FetchConvFeeResponse();
        HashMap<String, FetchConvFeeCombinations> convFeeMap = parseFetchConvFeeRespToMap(data);
        if (convFeeMap != null)
            fetchConvFeeResponse.setConvFeeChargesMap(convFeeMap);
        apiResponse.setPayuResponse(fetchConvFeeResponse);
    }

    public HashMap<String, FetchConvFeeCombinations> parseFetchConvFeeRespToMap(JSONObject data) {
        if (data != null) {
            JSONObject combinationsData = data.optJSONObject(PayuConstants.PAYU_COMBINATIONS);
            if (combinationsData != null) {
                String requestId = data.optString(PayuConstants.PAYU_REQUEST_UUID);
                Iterator<String> keysIterator = combinationsData.keys();
                HashMap<String, FetchConvFeeCombinations> convFeeMap = new HashMap<>();
                while (keysIterator.hasNext()) {
                    String combinationKey = keysIterator.next();
                    JSONObject bankCodeJson = combinationsData.optJSONObject(combinationKey);
                    if (bankCodeJson != null) {
                        JSONArray chargesJson = bankCodeJson.optJSONArray(PayuConstants.PAYU_CHARGES);
                        String combinationUUID = bankCodeJson.optString(PayuConstants.PAYU_COMBINATION_UUID);
                        FetchConvFeeCombinations feeCombinations = new FetchConvFeeCombinations();
                        feeCombinations.setCombinationKey(combinationKey);
                        feeCombinations.setCombinationUUID(combinationUUID);
                        feeCombinations.setRequestUuid(requestId);
                        ArrayList<Charges> chargesArrayList = new ArrayList<>();
                        for (int i = 0; i < Objects.requireNonNull(chargesJson).length(); i++) {
                            JSONObject chargeJsonObject = chargesJson.optJSONObject(i);
                            Charges charges = new Charges();
                            String chargeUuid = chargeJsonObject.optString(PayuConstants.PAYU_CHARGE_UUID);
                            charges.setChargeUuid(chargeUuid);
                            String chargeName = chargeJsonObject.optString(PayuConstants.PAYU_CHARGE_NAME);
                            charges.setChargeName(chargeName);
                            double baseFee = chargeJsonObject.optDouble(PayuConstants.PAYU_BASE_FEE);
                            charges.setBaseFee(baseFee);
                            double taxAmt = chargeJsonObject.optDouble(PayuConstants.PAYU_TAX_AMT);
                            charges.setTaxAmount(taxAmt);
                            String ruleId = chargeJsonObject.optString(PayuConstants.PAYU_RULE_ID);
                            charges.setRuleId(ruleId);
                            chargesArrayList.add(charges);
                            feeCombinations.setCharges(chargesArrayList);
                        }
                        convFeeMap.put(combinationKey, feeCombinations);
                    }
                }
                return convFeeMap;
            }
        }
        return null;
    }


}
