package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

public class TokenisedCardDetail implements Parcelable {
    public String cryptogram;
    public String cardPAR;
    public String cardNo;
    public String cardToken;
    public String cardName;
    public String cardMode;
    public String trid;
    public String tokenRefernceId;
    public IssuerToken issuerToken;
    public NetworkToken networkToken;

    public TokenisedCardDetail() {
    }

    protected TokenisedCardDetail(Parcel in) {
        cryptogram = in.readString();
        cardPAR = in.readString();
        cardNo = in.readString();
        cardToken = in.readString();
        cardName = in.readString();
        cardMode = in.readString();
        trid = in.readString();
        tokenRefernceId = in.readString();
        issuerToken = in.readParcelable(IssuerToken.class.getClassLoader());
        networkToken = in.readParcelable(NetworkToken.class.getClassLoader());

    }

    public static final Creator<TokenisedCardDetail> CREATOR = new Creator<TokenisedCardDetail>() {
        @Override
        public TokenisedCardDetail createFromParcel(Parcel in) {
            return new TokenisedCardDetail(in);
        }

        @Override
        public TokenisedCardDetail[] newArray(int size) {
            return new TokenisedCardDetail[size];
        }
    };

    public String getCryptogram() {
        return cryptogram;
    }

    public void setCryptogram(String cryptogram) {
        this.cryptogram = cryptogram;
    }

    public String getCardPAR() {
        return cardPAR;
    }

    public void setCardPAR(String cardPAR) {
        this.cardPAR = cardPAR;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getCardToken() {
        return cardToken;
    }

    public void setCardToken(String cardToken) {
        this.cardToken = cardToken;
    }

    public IssuerToken getIssuerToken() {
        return issuerToken;
    }

    public void setIssuerToken(IssuerToken issuerToken) {
        this.issuerToken = issuerToken;
    }

    public NetworkToken getNetworkToken() {
        return networkToken;
    }

    public void setNetworkToken(NetworkToken networkToken) {
        this.networkToken = networkToken;
    }

    public String getCardName() {
        return cardName;
    }

    public void setCardName(String cardName) {
        this.cardName = cardName;
    }

    public String getTrid() {
        return trid;
    }

    public void setTrid(String trid) {
        this.trid = trid;
    }

    public String getTokenRefernceId() {
        return tokenRefernceId;
    }

    public void setTokenRefernceId(String tokenRefernceId) {
        this.tokenRefernceId = tokenRefernceId;
    }

    public String getCardMode() {
        return cardMode;
    }

    public void setCardMode(String cardMode) {
        this.cardMode = cardMode;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(cryptogram);
        dest.writeString(cardPAR);
        dest.writeString(cardNo);
        dest.writeString(cardToken);
        dest.writeString(cardName);
        dest.writeString(cardMode);
        dest.writeString(trid);
        dest.writeString(tokenRefernceId);
        dest.writeParcelable(issuerToken, flags);
        dest.writeParcelable(networkToken, flags);

    }
}
