package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;

/**
 * Created by franklin.michael on 04/04/16.
 * Bean for #{@link PayuOfferDetails}
 * This Bean holds one user card and all the available offer for the user credentials.
 */
public class PayuUserOffer implements Parcelable {

    public PayuUserOffer() {
    }

    private StoredCard storedCard;
    private ArrayList<PayuOffer> availableCardOffers;

    protected PayuUserOffer(Parcel in) {
        storedCard = in.readParcelable(StoredCard.class.getClassLoader());
        availableCardOffers = in.createTypedArrayList(PayuOffer.CREATOR);
    }

    public static final Creator<PayuUserOffer> CREATOR = new Creator<PayuUserOffer>() {
        @Override
        public PayuUserOffer createFromParcel(Parcel in) {
            return new PayuUserOffer(in);
        }

        @Override
        public PayuUserOffer[] newArray(int size) {
            return new PayuUserOffer[size];
        }
    };

    public StoredCard getStoredCard() {
        return storedCard;
    }

    public void setStoredCard(StoredCard storedCard) {
        this.storedCard = storedCard;
    }

    public ArrayList<PayuOffer> getAvailableCardOffers() {
        return availableCardOffers;
    }

    public void setAvailableCardOffers(ArrayList<PayuOffer> availableCardOffers) {
        this.availableCardOffers = availableCardOffers;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeParcelable(storedCard, i);
        parcel.writeTypedList(availableCardOffers);
    }
}
