package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;

public class OfferInformation implements Parcelable {

    private String offerKey;
    private String type;
    private String title;
    private String description;
    private String tnc;
    private String tncLink;
    private double minTxnAmount;
    private double maxTxnAmount;
    private String offerType;
    private String validFrom;
    private String validTo;
    private boolean isNoCostEmi;
    private DiscountDetailsofOffers discountDetails;
    private ArrayList<PaymentOptionOfferinfo> nbOfferList;
    private ArrayList<PaymentOptionOfferinfo> walletOfferList;
    private ArrayList<PaymentOptionOfferinfo> upiOfferList;
    private ArrayList<PaymentOptionOfferinfo> bnplOfferList;
    private CardsOfferInfo cardsOfferInfo;
    private EmiOfferInfo emiOfferInfo;
    private ArrayList<PaymentOptionOfferinfo> clwOfferInfoList;
    private double amount;
    private double discount;
    private double discountedAmount;
    private String offerCategory;
    private boolean toDisplay;
    private boolean isUserVerificationRequired;
    private PayUUserDetails userDetails;

    public OfferInformation() {
    }

    public String getOfferKey() {
        return offerKey;
    }

    public void setOfferKey(String offerKey) {
        this.offerKey = offerKey;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTnc() {
        return tnc;
    }

    public void setTnc(String tnc) {
        this.tnc = tnc;
    }

    public String getTncLink() {
        return tncLink;
    }

    public void setTncLink(String tncLink) {
        this.tncLink = tncLink;
    }

    public double getMinTxnAmount() {
        return minTxnAmount;
    }

    public void setMinTxnAmount(double minTxnAmount) {
        this.minTxnAmount = minTxnAmount;
    }

    public double getMaxTxnAmount() {
        return maxTxnAmount;
    }

    public void setMaxTxnAmount(double maxTxnAmount) {
        this.maxTxnAmount = maxTxnAmount;
    }

    public String getOfferType() {
        return offerType;
    }

    public void setOfferType(String offerType) {
        this.offerType = offerType;
    }

    public String getValidFrom() {
        return validFrom;
    }

    public void setValidFrom(String validFrom) {
        this.validFrom = validFrom;
    }

    public String getValidTo() {
        return validTo;
    }

    public void setValidTo(String validTo) {
        this.validTo = validTo;
    }

    public boolean getIsNoCostEmi() {
        return isNoCostEmi;
    }

    public void setIsNoCostEmi(boolean isNoCostEmi) {
        this.isNoCostEmi = isNoCostEmi;
    }

    public DiscountDetailsofOffers getDiscountDetails() {
        return discountDetails;
    }

    public void setDiscountDetails(DiscountDetailsofOffers discountDetails) {
        this.discountDetails = discountDetails;
    }

    protected OfferInformation(Parcel in) {
        offerKey = in.readString();
        type = in.readString();
        title = in.readString();
        description = in.readString();
        tnc = in.readString();
        tncLink = in.readString();
        minTxnAmount = in.readInt();
        maxTxnAmount = in.readInt();
        offerType = in.readString();
        validFrom = in.readString();
        validTo = in.readString();
        isNoCostEmi = in.readByte() != 0;
        discountDetails = in.readParcelable(DiscountDetailsofOffers.class.getClassLoader());
        nbOfferList = in.createTypedArrayList(PaymentOptionOfferinfo.CREATOR);
        walletOfferList = in.createTypedArrayList(PaymentOptionOfferinfo.CREATOR);
        upiOfferList = in.createTypedArrayList(PaymentOptionOfferinfo.CREATOR);
        bnplOfferList = in.createTypedArrayList(PaymentOptionOfferinfo.CREATOR);
        cardsOfferInfo = in.readParcelable(CardsOfferInfo.class.getClassLoader());
        emiOfferInfo = in.readParcelable(EmiOfferInfo.class.getClassLoader());
        clwOfferInfoList = in.createTypedArrayList(PaymentOptionOfferinfo.CREATOR);
        amount = in.readDouble();
        discount = in.readDouble();
        discountedAmount = in.readDouble();
        offerCategory = in.readString();
        toDisplay = in.readByte() != 0;
        isUserVerificationRequired = in.readByte() != 0;
        userDetails = in.readParcelable(PayUUserDetails.class.getClassLoader());
    }

    public ArrayList<PaymentOptionOfferinfo> getNbOfferList() {
        return nbOfferList;
    }

    public void setNbOfferList(ArrayList<PaymentOptionOfferinfo> nbOfferList) {
        this.nbOfferList = nbOfferList;
    }

    public CardsOfferInfo getCardsOfferInfo() {
        return cardsOfferInfo;
    }

    public void setCardsOfferInfo(CardsOfferInfo cardsOfferInfo) {
        this.cardsOfferInfo = cardsOfferInfo;
    }

    public ArrayList<PaymentOptionOfferinfo> getWalletOfferList() {
        return walletOfferList;
    }

    public void setWalletOfferList(ArrayList<PaymentOptionOfferinfo> walletOfferList) {
        this.walletOfferList = walletOfferList;
    }

    public ArrayList<PaymentOptionOfferinfo> getUpiOfferList() {
        return upiOfferList;
    }

    public void setUpiOfferList(ArrayList<PaymentOptionOfferinfo> upiOfferList) {
        this.upiOfferList = upiOfferList;
    }

    public ArrayList<PaymentOptionOfferinfo> getBnplOfferList() {
        return bnplOfferList;
    }

    public void setBnplOfferList(ArrayList<PaymentOptionOfferinfo> bnplOfferList) {
        this.bnplOfferList = bnplOfferList;
    }


    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public EmiOfferInfo getEmiOfferInfo() {
        return emiOfferInfo;
    }

    public void setEmiOfferInfo(EmiOfferInfo emiOfferInfo) {
        this.emiOfferInfo = emiOfferInfo;
    }

    public double getAmount() {
        return amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getDiscount() {
        return discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public double getDiscountedAmount() {
        return discountedAmount;
    }

    public void setDiscountedAmount(double discountedAmount) {
        this.discountedAmount = discountedAmount;
    }

    public String getOfferCategory() {
        return offerCategory;
    }

    public void setOfferCategory(String offerCategory) {
        this.offerCategory = offerCategory;
    }

    public ArrayList<PaymentOptionOfferinfo> getClwOfferInfoList() {
        return clwOfferInfoList;
    }

    public void setClwOfferInfoList(ArrayList<PaymentOptionOfferinfo> clwOfferInfoList) {
        this.clwOfferInfoList = clwOfferInfoList;
    }

    public boolean isToDisplay() {
        return toDisplay;
    }

    public void setToDisplay(boolean toDisplay) {
        this.toDisplay = toDisplay;
    }

    public boolean isUserVerificationRequired() {
        return isUserVerificationRequired;
    }

    public void setUserVerificationRequired(boolean userVerificationRequired) {
        isUserVerificationRequired = userVerificationRequired;
    }

    public PayUUserDetails getUserDetails() {
        return userDetails;
    }

    public void setUserDetails(PayUUserDetails userDetails) {
        this.userDetails = userDetails;
    }

    public static final Creator<OfferInformation> CREATOR = new Creator<OfferInformation>() {
        @Override
        public OfferInformation createFromParcel(Parcel in) {
            return new OfferInformation(in);
        }

        @Override
        public OfferInformation[] newArray(int size) {
            return new OfferInformation[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(offerKey);
        parcel.writeString(type);
        parcel.writeString(title);
        parcel.writeString(description);
        parcel.writeString(tnc);
        parcel.writeString(tncLink);
        parcel.writeDouble(minTxnAmount);
        parcel.writeDouble(maxTxnAmount);
        parcel.writeString(offerType);
        parcel.writeString(validFrom);
        parcel.writeString(validTo);
        parcel.writeByte((byte) (isNoCostEmi ? 1 : 0));
        parcel.writeParcelable(discountDetails, i);
        parcel.writeTypedList(nbOfferList);
        parcel.writeTypedList(walletOfferList);
        parcel.writeTypedList(upiOfferList);
        parcel.writeTypedList(bnplOfferList);
        parcel.writeParcelable(cardsOfferInfo,i);
        parcel.writeParcelable(emiOfferInfo,i);
        parcel.writeTypedList(clwOfferInfoList);
        parcel.writeDouble(amount);
        parcel.writeDouble(discount);
        parcel.writeDouble(discountedAmount);
        parcel.writeString(offerCategory);
        parcel.writeByte((byte) (toDisplay ? 1 : 0));
        parcel.writeByte((byte) (isUserVerificationRequired ? 1 : 0));
        parcel.writeParcelable(userDetails, i);
    }
}
