package com.payu.india.Model;

import android.util.Log;

import com.payu.india.Payu.PayuConstants;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class CustomerDetails {

    private final String mobile;
    private final ArrayList<String> ifscCodes;

    private CustomerDetails(Builder builder) {
        this.mobile = builder.mobile;
        this.ifscCodes = builder.ifscCodes;
    }

    public JSONObject prepareCustomerDetailsObject() {
        JSONObject customerDetails = new JSONObject();
        try {
            customerDetails.put(PayuConstants.P_MOBILE, mobile);
            if (ifscCodes != null && !ifscCodes.isEmpty()) {
                JSONArray ifscArray = new JSONArray();
                for (String ifscCode : ifscCodes) {
                    ifscArray.put(ifscCode);
                }
                customerDetails.put(PayuConstants.P_IFSC_CODES, ifscArray);
            }
        } catch (JSONException e) {
            Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
        }
        return customerDetails;
    }

    public static class Builder {
        private String mobile;
        private  ArrayList<String> ifscCodes;


        public Builder setMobile(String mobile) {
            this.mobile = mobile;
            return this;
        }

        public Builder setIfscCodes(ArrayList<String> ifscCodes) {
            this.ifscCodes = ifscCodes;
            return this;
        }

        public CustomerDetails build() {
            return new CustomerDetails(this);
        }
    }
}
