/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.ValueAddedServiceApiListener;
import com.payu.india.Model.CardStatus;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ValueAddedServiceTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private ValueAddedServiceApiListener mValueAddedServiceApiListener;

    public ValueAddedServiceTask(ValueAddedServiceApiListener valueAddedServiceApiListener) {
        this.mValueAddedServiceApiListener = valueAddedServiceApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 4: {
                    url = new URL("https://bizcheckouttest.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            byte[] postParamsByte = payuConfig.getData().getBytes("UTF-8");
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                postData.setResult("ERROR");
                postData.setCode(5019);
                if (response.has("msg")) {
                    postData.setResult(response.getString("msg"));
                }
                if (response.has("netBankingStatus")) {
                    HashMap<String, Integer> netBankingStatus = new HashMap<String, Integer>();
                    JSONObject netBanking = response.getJSONObject("netBankingStatus");
                    Iterator keysIterator = netBanking.keys();
                    while (keysIterator.hasNext()) {
                        String bankCode = (String)keysIterator.next();
                        netBankingStatus.put(bankCode, netBanking.getJSONObject(bankCode).getInt("up_status"));
                    }
                    payuResponse.setNetBankingDownStatus(netBankingStatus);
                    postData.setResult("SUCCESS");
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                }
                if (response.has("issuingBankDownBins")) {
                    HashMap<String, CardStatus> issuingBankStatus = new HashMap<String, CardStatus>();
                    JSONArray issuingBank = response.getJSONArray("issuingBankDownBins");
                    int length = issuingBank.length();
                    for (int i = 0; i < length; ++i) {
                        int binArrayLength = issuingBank.getJSONObject(i).getJSONArray("bins_arr").length();
                        for (int j = 0; j < binArrayLength; ++j) {
                            CardStatus cardStatus = new CardStatus();
                            cardStatus.setBankName(issuingBank.getJSONObject(i).getString("title"));
                            cardStatus.setStatusCode(issuingBank.getJSONObject(i).getInt("status"));
                            issuingBankStatus.put(issuingBank.getJSONObject(i).getJSONArray("bins_arr").getString(j), cardStatus);
                        }
                    }
                    payuResponse.setIssuingBankStatus(issuingBankStatus);
                    postData.setResult("SUCCESS");
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                }
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Exception " + e.getMessage()));
        }
        catch (IOException | JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Exception " + e.getMessage()));
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mValueAddedServiceApiListener.onValueAddedServiceApiResponse(payuResponse);
    }
}

