/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateDeviceIdTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private final String TAG = this.getClass().getSimpleName();

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PostData postData = new PostData();
        PayuResponse payuResponse = new PayuResponse();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://sandbox.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "fems/sdk/v1/device-details").setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader("fetch_device_id")).setRequestType("application/json").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, true);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has("status") && response.optInt("status") == 1) {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                } else {
                    postData.setResult("Invalid GAID Request");
                    postData.setStatus("ERROR");
                }
            }
        }
        catch (MalformedURLException e) {
            Log.d((String)this.TAG, (String)(" MalformedURLException" + e.getMessage()));
            postData.setCode(5022);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (ProtocolException e) {
            Log.d((String)this.TAG, (String)(" ProtocolException " + e.getMessage()));
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)(" IOException " + e.getMessage()));
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)(" JSONException " + e.getMessage()));
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
    }
}

