/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.GetTransactionInfoApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class GetTransactionInfoTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    GetTransactionInfoApiListener mGetTransactionInfoApiListener;

    public GetTransactionInfoTask(GetTransactionInfoApiListener getTransactionInfoApiListener) {
        this.mGetTransactionInfoApiListener = getTransactionInfoApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            byte[] postParamsByte = payuConfig.getData().getBytes(StandardCharsets.UTF_8);
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has("msg")) {
                    postData.setResult(response.getString("msg"));
                }
                if (response.has("status") && response.getInt("status") == 0) {
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                }
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Exception " + e.getMessage()));
        }
        catch (IOException | JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Exception " + e.getMessage()));
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mGetTransactionInfoApiListener.onGetTransactionApiListener(payuResponse);
    }
}

