/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.GetEmiAmountAccordingToInterestApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuEmiAmountAccordingToInterest;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class GetEmiAmountAccordingToInterestTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private final String TAG = this.getClass().getSimpleName();
    GetEmiAmountAccordingToInterestApiListener apiListener;

    public GetEmiAmountAccordingToInterestTask(GetEmiAmountAccordingToInterestApiListener apiListener) {
        this.apiListener = apiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(jsonResponse);
                if (jsonResponse.has("msg")) {
                    postData.setResult(jsonResponse.getString("msg"));
                }
                if (jsonResponse.has("status") && jsonResponse.getInt("status") == 0) {
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                } else {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                }
                Iterator keys = jsonResponse.keys();
                HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>> emiResponse = new HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>>();
                while (keys.hasNext()) {
                    String bankCode = ((String)keys.next()).toString();
                    JSONObject bankBasedResponse = new JSONObject(jsonResponse.getString(bankCode));
                    Iterator nestedKeys = bankBasedResponse.keys();
                    HashMap<String, PayuEmiAmountAccordingToInterest> emiResponsePerEMIMonthBasis = new HashMap<String, PayuEmiAmountAccordingToInterest>();
                    while (nestedKeys.hasNext()) {
                        String emiMonth = ((String)nestedKeys.next()).toString();
                        JSONObject emiBasedResponse = new JSONObject(bankBasedResponse.getString(emiMonth));
                        PayuEmiAmountAccordingToInterest payuEmiAmountAccordingToInterest = new PayuEmiAmountAccordingToInterest();
                        payuEmiAmountAccordingToInterest.setEmiBankInterest(emiBasedResponse.optString("emiBankInterest"));
                        payuEmiAmountAccordingToInterest.setBankRate(emiBasedResponse.optString("bankRate"));
                        payuEmiAmountAccordingToInterest.setBankCharge(emiBasedResponse.optString("bankCharge"));
                        payuEmiAmountAccordingToInterest.setAmount(emiBasedResponse.optString("amount"));
                        payuEmiAmountAccordingToInterest.setCardType(emiBasedResponse.optString("card_type"));
                        payuEmiAmountAccordingToInterest.setEmiValue(emiBasedResponse.optString("emi_value"));
                        payuEmiAmountAccordingToInterest.setEmiInterestPaid(emiBasedResponse.optString("emi_interest_paid"));
                        payuEmiAmountAccordingToInterest.setTenure(emiBasedResponse.optString("tenure"));
                        emiResponsePerEMIMonthBasis.put(emiMonth, payuEmiAmountAccordingToInterest);
                    }
                    emiResponse.put(bankCode, emiResponsePerEMIMonthBasis);
                }
                payuResponse.setPayuEmiAmountAccordingToInterest(emiResponse);
            }
        }
        catch (MalformedURLException e) {
            Log.d((String)this.TAG, (String)("MalformedURLException " + e.getMessage()));
        }
        catch (ProtocolException e) {
            Log.d((String)this.TAG, (String)("ProtocolException " + e.getMessage()));
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)("IOException " + e.getMessage()));
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)("JSONException " + e.getMessage()));
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.apiListener.onGetEmiAmountAccordingToInterestApiResponse(payuResponse);
    }
}

