/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.BinInfoApiListener;
import com.payu.india.Model.CardInformation;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.v2ApiResponseParser.V2ApiResponseParser;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class BinInfoTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private final String TAG = this.getClass().getSimpleName();
    BinInfoApiListener apiListener;

    public BinInfoTask(BinInfoApiListener apiListener) {
        this.apiListener = apiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(jsonResponse);
                if (jsonResponse.has("status") && jsonResponse.optInt("status") == 0) {
                    postData.setCode(5050);
                    postData.setStatus("ERROR");
                    postData.setResult(jsonResponse.optString("data") != null ? jsonResponse.optString("data") : "Something went wong.");
                } else if (jsonResponse.optInt("status") == 1) {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                    CardInformation cardInformation = new CardInformation();
                    JSONObject data = jsonResponse.optJSONObject("data");
                    if (data != null) {
                        new V2ApiResponseParser().parseBinInfoResponse(data, cardInformation);
                    }
                    payuResponse.setCardInformation(cardInformation);
                }
            }
        }
        catch (MalformedURLException e) {
            Log.d((String)this.TAG, (String)("MalformedURLException " + e.getMessage()));
        }
        catch (ProtocolException e) {
            Log.d((String)this.TAG, (String)("ProtocolException " + e.getMessage()));
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)("IOException " + e.getMessage()));
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)("JSONException " + e.getMessage()));
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.apiListener.onBinInfoApiResponse(payuResponse);
    }
}

