package com.payu.india.Tasks;

import com.payu.india.Interfaces.GetTokenisedCardApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.StoredCard;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

import javax.net.ssl.HttpsURLConnection;

public class GetTokenisedCardTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private GetTokenisedCardApiListener mGetTokenisedCardApiListener;

    public GetTokenisedCardTask(GetTokenisedCardApiListener getTokenisedCardApiListener) {
        mGetTokenisedCardApiListener = getTokenisedCardApiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }

            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);

                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has(PayuConstants.USER_CARD)) { // yey! we have stored cards..
                    JSONObject cardsList = response.getJSONObject(PayuConstants.USER_CARD);
                    Iterator<String> keysIterator = cardsList.keys();
                    ArrayList<StoredCard> userCardArrayList = new ArrayList<>();

                    while (keysIterator.hasNext()) {
                        String cardToken = keysIterator.next();
                        StoredCard userCard = new StoredCard();
                        JSONObject card = cardsList.getJSONObject(cardToken);
                        userCard.setCardMode(card.getString(PayuConstants.CARD_MODE));
                        userCard.setMaskedCardNumber(card.getString(PayuConstants.CARD_NO));
                        userCard.setCardToken(card.getString(PayuConstants.CARD_TOKEN));
                        userCard.setCardName(card.getString(PayuConstants.CARD_NAME));
                        userCard.setCardType(card.getString(PayuConstants.CARD_TYPE));
                        userCard.setCardBrand(card.getString(PayuConstants.CARD_BRAND));
                        userCard.setCardBin(card.getString(PayuConstants.CARD_BIN));
                        userCard.setIsDomestic(card.getString(PayuConstants.IS_DOMESTIC));
                        userCard.setCardPar(card.getString(PayuConstants.PAR));
                        userCardArrayList.add(userCard);
                    }
                    payuResponse.setStoredCards(userCardArrayList);
                }

                if (response.has(PayuConstants.MSG)) {
                    postData.setResult(response.getString(PayuConstants.MSG));
                }
                if (response.has(PayuConstants.STATUS)) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                } else {
                    postData.setCode(PayuErrors.GET_USER_CARD_EXCEPTION);
                    postData.setStatus(PayuConstants.ERROR);
                }
            }
        } catch (MalformedURLException e) {
            postData.setCode(PayuErrors.MALFORMED_URL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (ProtocolException e) {
            postData.setCode(PayuErrors.PROTOCOL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (JSONException e) {
            postData.setCode(PayuErrors.JSON_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (IOException e) {
            postData.setCode(PayuErrors.IO_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        }

        // gotta return payuResponse
        payuResponse.setResponseStatus(postData);
        //payuResponse.setStoredCards(userCardArrayList);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mGetTokenisedCardApiListener.onGetTokenisedCardResponse(payuResponse);
    }
}
