//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Tasks;

import android.util.Log;

import com.payu.india.Interfaces.GetOfferStatusApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuOffer;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Iterator;

import javax.net.ssl.HttpsURLConnection;

/**
 * Created by franklin on 7/3/15.
 * Async task which takes care of getting offer status
 * Takes PayuConfig as input and sends PayuResponse to the calling activity
 * Activity which calls {@link GetOfferStatusTask } should implement {@link GetOfferStatusApiListener}
 */
public class GetOfferStatusTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private  final String TAG = getClass().getSimpleName();

    GetOfferStatusApiListener mGetOfferStatusApiListener;

    public GetOfferStatusTask(GetOfferStatusApiListener getOfferStatusApiListener) {
        mGetOfferStatusApiListener = getOfferStatusApiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }


            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);

                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has(PayuConstants.MSG)) {
                    postData.setResult(response.getString(PayuConstants.MSG));
                }
                if (response.has(PayuConstants.STATUS) && response.getInt(PayuConstants.STATUS) == 0) {
                    postData.setCode(PayuErrors.INVALID_HASH);
                    postData.setStatus(PayuConstants.ERROR);
                } else {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                }
                PayuOffer payuOffer = new PayuOffer();

                Iterator<String> keys = response.keys();

                while (keys.hasNext()) {
                    switch (keys.next()) {
                        case PayuConstants.STATUS:
                            payuOffer.setStatus(response.getString(PayuConstants.STATUS));
                            break;
                        case PayuConstants.MSG:
                            payuOffer.setMsg(response.getString(PayuConstants.MSG));
                            break;
                        case PayuConstants.ERROR_CODE:
                            payuOffer.setErrorCode(response.getString(PayuConstants.ERROR_CODE));
                            break;
                        case PayuConstants.OFFER_KEY:
                            payuOffer.setOfferKey(response.getString(PayuConstants.OFFER_KEY));
                            break;
                        case PayuConstants.OFFER_TYPE:
                            payuOffer.setOfferType(response.getString(PayuConstants.OFFER_TYPE));
                            break;
                        case PayuConstants.OFFER_AVAILED_COUNT:
                            payuOffer.setOfferAvailedCount(response.getString(PayuConstants.OFFER_AVAILED_COUNT));
                            break;
                        case PayuConstants.OFFER_REMAINING_COUNT:
                            payuOffer.setOfferRemainingCount(response.getString(PayuConstants.OFFER_REMAINING_COUNT));
                            break;
                        case PayuConstants.DISCOUNT:
                            payuOffer.setDiscount(response.getString(PayuConstants.DISCOUNT));
                            break;
                        case PayuConstants.CATEGORY:
                            payuOffer.setCategory(response.getString(PayuConstants.CATEGORY));
                            break;
                    }
                }

                payuResponse.setPayuOffer(payuOffer);
            }

        } catch (MalformedURLException e) {
            Log.d(TAG, "MalformedURLException " + e.getMessage());
        } catch (ProtocolException e) {
            Log.d(TAG, "ProtocolException " + e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, "IOException " + e.getMessage());
        } catch (JSONException e) {
            Log.d(TAG, "JSONException " + e.getMessage());
        }

        // gotta return payuResponse
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mGetOfferStatusApiListener.onGetOfferStatusApiResponse(payuResponse);
    }
}
