//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Tasks;

import static com.payu.india.Payu.PayuConstants.DEBITCARD;
import static com.payu.paymentparamhelper.PayuConstants.BINS_DATA;
import static com.payu.paymentparamhelper.PayuConstants.BIN_LEVEL;
import static com.payu.paymentparamhelper.PayuConstants.CC;
import static com.payu.paymentparamhelper.PayuConstants.CONVENIENCE_FEE_DATA;
import static com.payu.paymentparamhelper.PayuConstants.CONVENIENCE_FEE;
import static com.payu.paymentparamhelper.PayuConstants.DATA;
import static com.payu.paymentparamhelper.PayuConstants.DC;
import static com.payu.paymentparamhelper.PayuConstants.GST;
import static com.payu.paymentparamhelper.PayuConstants.PG_BANK_CODE;

import android.util.Log;

import com.payu.india.Interfaces.BinInfoApiListener;
import com.payu.india.Interfaces.EligibleBinsForEMIApiListener;
import com.payu.india.Model.CardInformation;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.v2ApiResponseParser.V2ApiResponseParser;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

/**
 * Async task which takes care of getting Eligible Bins for EMI
 * Takes PayuConfig as input and sends PayuResponse to the calling activity
 * Activity which calls {@link BinInfoTask } should implement {@link EligibleBinsForEMIApiListener}
 */
public class BinInfoTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private  final String TAG = getClass().getSimpleName();

    BinInfoApiListener apiListener;

    public BinInfoTask(BinInfoApiListener apiListener) {
        this.apiListener = apiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }


            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);

                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(jsonResponse);
                if (jsonResponse.has(PayuConstants.STATUS) && jsonResponse.optInt(PayuConstants.STATUS) == 0) {
                    postData.setCode(PayuErrors.GET_BIN_INFO_API_EXCEPTION);
                    postData.setStatus(PayuConstants.ERROR);
                    postData.setResult(jsonResponse.optString(DATA) != null ? jsonResponse.optString(DATA) : PayuConstants.SOMETHING_WENT_WRONG_ERROR);
                } else if (jsonResponse.optInt(PayuConstants.STATUS) == 1) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                    CardInformation cardInformation = new CardInformation();
                    JSONObject data = jsonResponse.optJSONObject(DATA);
                    if (data != null)
                        new V2ApiResponseParser().parseBinInfoResponse(data, cardInformation);
                    payuResponse.setCardInformation(cardInformation);
                }

            }
        } catch (MalformedURLException e) {
            Log.d(TAG, "MalformedURLException " + e.getMessage());
        } catch (ProtocolException e) {
            Log.d(TAG, "ProtocolException " + e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, "IOException " + e.getMessage());
        } catch (JSONException e) {
            Log.d(TAG, "JSONException " + e.getMessage());
        }

        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        apiListener.onBinInfoApiResponse(payuResponse);
    }
}
