package com.payu.india.Model.validateOffer;

import com.payu.india.Model.PaymentDetailsForOffer;
import com.payu.india.Model.UserDetailsForOffer;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuUtils;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Objects;

public class ValidateOfferRequest extends V2ApiBase {
    private String amount;
    private JSONArray offerKeys;
    private PaymentDetailsForOffer paymentDetailsForOffer;
    private UserDetailsForOffer userDetailsForOffer;
    private boolean autoApply;
    private String skuDetails;

    private ValidateOfferRequest(Builder builder) {
        this.amount = builder.amount;
        this.offerKeys = builder.offerKeys;
        this.paymentDetailsForOffer = builder.paymentDetailsForOffer;
        this.userDetailsForOffer = builder.userDetailsForOffer;
        this.autoApply = builder.autoApply;
        this.skuDetails = builder.skuDetails;
    }

    @Override
    public String getJson() {
        try {
            JSONObject jsonObject = new JSONObject();
            if (skuDetails != null) {
                jsonObject = getSKUJson(skuDetails);
            }
            jsonObject.put(PayuConstants.P_AMOUNT, amount);
            if (offerKeys != null && offerKeys.length() > 0) {
                jsonObject.put(PayuConstants.P_OFFER_KEY, offerKeys);
            }
            jsonObject.put(PayuConstants.P_PAYMENT_DETAILS, paymentDetailsForOffer.prepareJson());
            jsonObject.put(PayuConstants.P_USER_DETAILS, userDetailsForOffer.prepareJson());
            jsonObject.put(PayuConstants.P_AUTO_APPLY, autoApply);
            return jsonObject.toString();
        } catch (JSONException e) {
            return null;
        }
    }

    public JSONObject getJsonValue() {
        try {
            JSONObject jsonObject = new JSONObject();
            if (skuDetails != null) {
                jsonObject = getSKUJson(skuDetails);
            }
            jsonObject.put(PayuConstants.P_AMOUNT, amount);
            if (offerKeys != null && offerKeys.length() > 0) {
                jsonObject.put(PayuConstants.P_OFFER_KEY, offerKeys);
            }
            jsonObject.put(PayuConstants.P_PAYMENT_DETAILS, paymentDetailsForOffer.prepareJson());
            jsonObject.put(PayuConstants.P_USER_DETAILS, userDetailsForOffer.prepareJson());
            jsonObject.put(PayuConstants.P_AUTO_APPLY, autoApply);
            return jsonObject;
        } catch (JSONException e) {
            return null;
        }
    }

    public static class Builder {
        private final String amount;
        private JSONArray offerKeys;
        private PaymentDetailsForOffer paymentDetailsForOffer;
        private UserDetailsForOffer userDetailsForOffer;
        private boolean autoApply;
        private String skuDetails;

        public Builder(String amount){
            this.amount = amount;
        }

        public Builder setOfferKey(JSONArray offerKeys) {
            this.offerKeys = offerKeys;
            return this;
        }

        public Builder setPaymentDetails(PaymentDetailsForOffer paymentDetailsForOffer) {
            this.paymentDetailsForOffer = paymentDetailsForOffer;
            return this;
        }

        public Builder setAutoApply(boolean autoApply) {
            this.autoApply = autoApply;
            return this;
        }

        public Builder setuserDetails(UserDetailsForOffer userDetailsForOffer) {
            this.userDetailsForOffer = userDetailsForOffer;
            return this;
        }

        public Builder setSkuDetails(String skuDetails) {
            this.skuDetails = skuDetails;
            return this;
        }

        public ValidateOfferRequest build() {
            return new ValidateOfferRequest(this);
        }
    }

    private JSONObject getSKUJson(String skuDetails) {
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_SKU_M_ID, PayuConstants.P_SKU_ID);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_SKU_M_AMOUNT, PayuConstants.P_SKU_AMOUNT);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.OFFER_KEY, PayuConstants.P_OFFER_KEY);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_AUTO_APPLY_M_OFFER, PayuConstants.P_AUTO_APPLY);

        try {
            JSONObject skuJsonObject = new JSONObject(skuDetails);
            JSONArray skuJsonArray = skuJsonObject.getJSONArray(PayuConstants.P_SKU_DETAILS);
            JSONObject validateSku = new JSONObject();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(PayuConstants.P_SKUS, skuJsonArray);
            validateSku.put(PayuConstants.PAYU_SKUS_DETAILS, jsonObject);
            return validateSku;

        } catch (JSONException jsonException) {
            return new JSONObject();
        }
    }

}
