package com.payu.india.Model.binBaseDetails;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.NonNull;

import com.payu.india.Model.CardInformation;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeCombinations;
import com.payu.india.Model.validateOffer.ValidateOfferDetails;

import java.util.HashMap;
import java.util.Map;

public class BinBaseDetailsResponse implements Parcelable {
    private CardInformation cardInformation;
    private ValidateOfferDetails validateOfferDetails;
    private HashMap<String, FetchConvFeeCombinations> convFeeChargesMap;

    public BinBaseDetailsResponse() {
    }

    protected BinBaseDetailsResponse(Parcel in) {
        cardInformation = in.readParcelable(CardInformation.class.getClassLoader());
        validateOfferDetails = in.readParcelable(ValidateOfferDetails.class.getClassLoader());
        int size = in.readInt();
        convFeeChargesMap = new HashMap<>(size); // Initialize with capacity
        for (int i = 0; i < size; i++) {
            String key = in.readString();
            FetchConvFeeCombinations value = in.readParcelable(FetchConvFeeCombinations.class.getClassLoader());
            convFeeChargesMap.put(key, value);
        }


    }

    public static final Creator<BinBaseDetailsResponse> CREATOR = new Creator<BinBaseDetailsResponse>() {
        @Override
        public BinBaseDetailsResponse createFromParcel(Parcel in) {
            return new BinBaseDetailsResponse(in);
        }

        @Override
        public BinBaseDetailsResponse[] newArray(int size) {
            return new BinBaseDetailsResponse[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int i) {
        parcel.writeParcelable(cardInformation, i);
        parcel.writeParcelable(validateOfferDetails, i);
        parcel.writeInt(convFeeChargesMap.size());
        for (Map.Entry<String, FetchConvFeeCombinations> entry : convFeeChargesMap.entrySet()) {
            parcel.writeString(entry.getKey());
            parcel.writeParcelable(entry.getValue(), i); // Assuming FetchConvFeeCombinations is Parcelable
        }
    }

    public CardInformation getCardInformation() {
        return cardInformation;
    }

    public void setCardInformation(CardInformation cardInformation) {
        this.cardInformation = cardInformation;
    }

    public ValidateOfferDetails getValidateOfferDetails() {
        return validateOfferDetails;
    }

    public void setValidateOfferDetails(ValidateOfferDetails validateOfferDetails) {
        this.validateOfferDetails = validateOfferDetails;
    }

    public HashMap<String, FetchConvFeeCombinations> getConvFeeChargesMap() {
        return convFeeChargesMap;
    }

    public void setConvFeeChargesMap(HashMap<String, FetchConvFeeCombinations> convFeeChargesMap) {
        this.convFeeChargesMap = convFeeChargesMap;
    }
}
