package com.payu.india.Model.adsinformation;

import android.util.Log;

import com.payu.india.Payu.PayuConstants;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONException;
import org.json.JSONObject;

public class AdsPayUIdApiRequestModel extends V2ApiBase {
    private String source;
    private String requestId;
    private String payUID;

    private AdsPayUIdApiRequestModel(Builder builder) {
        this.source = builder.source;
        this.requestId = builder.requestId;
        this.payUID = builder.payUID;
    }

    @Override
    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PayuConstants.PAYU_SOURCE, source);
            jsonObject.put(PayuConstants.CP_ADS_PAYUID, payUID);
            jsonObject.put(PayuConstants.CP_ADS_REQUEST_ID, requestId);
        } catch (JSONException e) {
            Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private String source;
        private String requestId;
        private String payUID;


        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder setPayUID(String payUID) {
            this.payUID = payUID;
            return this;
        }

        public AdsPayUIdApiRequestModel build() {
            return new AdsPayUIdApiRequestModel(this);
        }
    }
}

