package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;

public class PayUEmiTenures extends PaymentProductDetails implements Parcelable {

    private String bankCode; // bank code given by payu
    private String minAmount; // min amount for transaction
    private String maxAmount; // max amount for transaction
    private String tenure; //emi tenure in months
    private String interestRate; //emi interest rate
    private String monthlyEmi; //monthly Emi
    private String interestCharged; //emi interest Charged
    private String paybackAmount; //emi payback Amount
    private String bankCharge; //emi bank Charge
    private String additionalCharge; // additional charge for transaction
    private boolean isBankDown; // Is Bank down
    private ArrayList<PayuOffer> offerDetailsList; // list of offers applicable on bankcode
    private Boolean status; // eligibility status
    private String reason; // reason if sttaus = false

    public PayUEmiTenures() {
    }

    protected PayUEmiTenures(Parcel in) {
        bankCode = in.readString();
        minAmount = in.readString();
        maxAmount = in.readString();
        tenure = in.readString();
        interestRate = in.readString();
        monthlyEmi = in.readString();
        interestCharged = in.readString();
        paybackAmount = in.readString();
        bankCharge = in.readString();
        additionalCharge = in.readString();
        isBankDown = in.readByte() != 0;
        offerDetailsList = in.createTypedArrayList(PayuOffer.CREATOR);
        byte tmpStatus = in.readByte();
        status = tmpStatus == 0 ? null : tmpStatus == 1;
        reason = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(bankCode);
        dest.writeString(minAmount);
        dest.writeString(maxAmount);
        dest.writeString(tenure);
        dest.writeString(interestRate);
        dest.writeString(monthlyEmi);
        dest.writeString(interestCharged);
        dest.writeString(paybackAmount);
        dest.writeString(bankCharge);
        dest.writeString(additionalCharge);
        dest.writeByte((byte) (isBankDown ? 1 : 0));
        dest.writeTypedList(offerDetailsList);
        dest.writeByte((byte) (status == null ? 0 : status ? 1 : 2));
        dest.writeString(reason);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PayUEmiTenures> CREATOR = new Creator<PayUEmiTenures>() {
        @Override
        public PayUEmiTenures createFromParcel(Parcel in) {
            return new PayUEmiTenures(in);
        }

        @Override
        public PayUEmiTenures[] newArray(int size) {
            return new PayUEmiTenures[size];
        }
    };

    public String getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(String minAmount) {
        this.minAmount = minAmount;
    }

    public String getMaxAmount() {
        return maxAmount;
    }

    public void setMaxAmount(String maxAmount) {
        this.maxAmount = maxAmount;
    }

    public String getTenure() {
        return tenure;
    }

    public void setTenure(String tenure) {
        this.tenure = tenure;
    }

    public String getInterestRate() {
        return interestRate;
    }

    public void setInterestRate(String interestRate) {
        this.interestRate = interestRate;
    }

    public String getMonthlyEmi() {
        return monthlyEmi;
    }

    public void setMonthlyEmi(String monthlyEmi) {
        this.monthlyEmi = monthlyEmi;
    }

    public String getInterestCharged() {
        return interestCharged;
    }

    public void setInterestCharged(String interestCharged) {
        this.interestCharged = interestCharged;
    }

    public String getPaybackAmount() {
        return paybackAmount;
    }

    public void setPaybackAmount(String paybackAmount) {
        this.paybackAmount = paybackAmount;
    }

    public String getBankCharge() {
        return bankCharge;
    }

    public void setBankCharge(String bankCharge) {
        this.bankCharge = bankCharge;
    }

    public String getAdditionalCharge() {
        return additionalCharge;
    }

    public void setAdditionalCharge(String additionalCharge) {
        this.additionalCharge = additionalCharge;
    }

    public boolean isBankDown() {
        return isBankDown;
    }

    public void setBankDown(boolean bankDown) {
        isBankDown = bankDown;
    }

    public ArrayList<PayuOffer> getOfferDetailsList() {
        return offerDetailsList;
    }

    public void setOfferDetailsList(ArrayList<PayuOffer> offerDetailsList) {
        this.offerDetailsList = offerDetailsList;
    }

    public Boolean getStatus() {
        return status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

}
