package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;

public class LookupDetails implements Parcelable {

    private ArrayList<String> supportedCardSchemes;
    private ArrayList<McpConversionBean> mcpConversionBeans;

    public LookupDetails(Parcel in) {
        supportedCardSchemes = in.createStringArrayList();
        mcpConversionBeans = in.createTypedArrayList(McpConversionBean.CREATOR);
    }

    public LookupDetails() {

    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringList(supportedCardSchemes);
        dest.writeTypedList(mcpConversionBeans);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<LookupDetails> CREATOR = new Creator<LookupDetails>() {
        @Override
        public LookupDetails createFromParcel(Parcel in) {
            return new LookupDetails(in);
        }

        @Override
        public LookupDetails[] newArray(int size) {
            return new LookupDetails[size];
        }
    };

    public ArrayList<String> getSupportedCardSchemes() {
        return supportedCardSchemes;
    }

    public void setSupportedCardSchemes(ArrayList<String> supportedCardSchemes) {
        this.supportedCardSchemes = supportedCardSchemes;
    }

    public ArrayList<McpConversionBean> getMcpConversionBeans() {
        return mcpConversionBeans;
    }

    public void setMcpConversionBeans(ArrayList<McpConversionBean> mcpConversionBeans) {
        this.mcpConversionBeans = mcpConversionBeans;
    }

}
