package com.payu.india.Model;

import android.util.Log;

import com.payu.india.Payu.PayuConstants;

import org.json.JSONException;
import org.json.JSONObject;

public class GetTransactionDetails {

    private final double amount;
    private final String additionalCharges;
    private final String percentageAdditionalCharges;
    private final boolean preAuthorize;

    private GetTransactionDetails(Builder builder) {
        this.amount = builder.amount;
        this.additionalCharges = builder.additionalCharges;
        this.percentageAdditionalCharges = builder.percentageAdditionalCharges;
        this.preAuthorize = builder.preAuthorize;
    }

    public JSONObject prepareTransactionDetailsJson() {
        JSONObject transactionDetailsObject = new JSONObject();
        try {
            transactionDetailsObject.put(PayuConstants.P_AMOUNT, amount);
            if (preAuthorize) {
                transactionDetailsObject.put(PayuConstants.P_PRE_AUTHORIZE, 1);
            }
            if (additionalCharges != null && !additionalCharges.trim().isEmpty())
                transactionDetailsObject.put(PayuConstants.ADDITIONAL_CHARGES, additionalCharges);
            if (percentageAdditionalCharges != null && !percentageAdditionalCharges.trim().isEmpty())
                transactionDetailsObject.put(PayuConstants.PERCENTAGE_ADDITIONAL_CHARGES, percentageAdditionalCharges);
        } catch (JSONException e) {
            Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
        }
        return transactionDetailsObject;
    }

    public static class Builder {

        private double amount = 0.0d;
        private String additionalCharges;
        private String percentageAdditionalCharges;
        private boolean preAuthorize;

        public Builder setAmount(double amount) {
            this.amount = amount;
            return this;
        }

        public Builder setAdditionalCharges(String additionalCharges) {
            this.additionalCharges = additionalCharges;
            return this;
        }

        public Builder setPercentageAdditionalCharges(String percentageAdditionalCharges) {
            this.percentageAdditionalCharges = percentageAdditionalCharges;
            return this;
        }

        public Builder setPreAuthorize(boolean preAuthorize) {
            this.preAuthorize = preAuthorize;
            return this;
        }

        public GetTransactionDetails build() {
            return new GetTransactionDetails(this);
        }
    }
}
