/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks.base;

import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class PayUAsyncTask<Params, Progress, Result> {
    private volatile Status mStatus = Status.PENDING;
    private final AtomicBoolean mCancelled = new AtomicBoolean();
    private final AtomicBoolean mTaskInvoked = new AtomicBoolean();
    private final WorkerRunnable<Params, Result> mWorker;
    private final FutureTask<Result> mFuture;
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final Handler mainHandler;

    public PayUAsyncTask() {
        this((Looper)null);
    }

    public PayUAsyncTask(@Nullable Handler handler) {
        this(handler != null ? handler.getLooper() : null);
    }

    public PayUAsyncTask(@Nullable Looper callbackLooper) {
        this.mainHandler = callbackLooper == null || callbackLooper == Looper.getMainLooper() ? new Handler(Looper.getMainLooper()) : new Handler(callbackLooper);
        this.mWorker = new WorkerRunnable<Params, Result>(){

            @Override
            public Result call() throws Exception {
                PayUAsyncTask.this.mTaskInvoked.set(true);
                Object result = null;
                if (Thread.currentThread().isAlive()) {
                    try {
                        PayUAsyncTask.this.mStatus = Status.RUNNING;
                        result = PayUAsyncTask.this.doInBackground(this.mParams);
                        Binder.flushPendingCommands();
                    }
                    catch (Throwable tr) {
                        PayUAsyncTask.this.mCancelled.set(true);
                        throw tr;
                    }
                    finally {
                        PayUAsyncTask.this.postResult(result);
                    }
                }
                return result;
            }
        };
        this.mFuture = new FutureTask<Result>(this.mWorker){

            @Override
            protected void done() {
                try {
                    PayUAsyncTask.this.postResultIfNotInvoked(this.get());
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("An error occurred while executing doInBackground()", e.getCause());
                }
                catch (CancellationException e) {
                    PayUAsyncTask.this.postResultIfNotInvoked(null);
                }
            }
        };
    }

    @WorkerThread
    protected abstract Result doInBackground(Params ... var1);

    @MainThread
    public final PayUAsyncTask<Params, Progress, Result> execute(Params ... params) {
        return this.executeOnExecutor(this.executor, params);
    }

    @MainThread
    public final PayUAsyncTask<Params, Progress, Result> executeOnExecutor(Executor exec, Params ... params) {
        if (this.mStatus != Status.PENDING) {
            switch (this.mStatus) {
                case RUNNING: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case FINISHED: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
        }
        this.mStatus = Status.RUNNING;
        this.onPreExecute();
        this.mWorker.mParams = params;
        exec.execute(this.mFuture);
        return this;
    }

    private void postResultIfNotInvoked(Result result) {
        boolean wasTaskInvoked = this.mTaskInvoked.get();
        if (!wasTaskInvoked) {
            this.postResult(result);
        }
    }

    private void postResult(Result result) {
        this.mainHandler.post(() -> this.onPostExecute(result));
    }

    public final Status getStatus() {
        return this.mStatus;
    }

    public final boolean isCancelled() {
        return this.mCancelled.get();
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.mCancelled.set(true);
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    public final Result get() throws InterruptedException, ExecutionException {
        return this.mFuture.get();
    }

    public final Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mFuture.get(timeout, unit);
    }

    @SafeVarargs
    @MainThread
    protected final void onProgressUpdate(Progress ... values) {
    }

    @MainThread
    protected void onPreExecute() {
    }

    @MainThread
    protected void onPostExecute(Result result) {
        this.mStatus = Status.FINISHED;
    }

    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }

    private static abstract class WorkerRunnable<Params, Result>
    implements Callable<Result> {
        Params[] mParams;

        private WorkerRunnable() {
        }
    }
}

