/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.V2ApiResponseListener;
import com.payu.india.Model.ApiResponse;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiTask
extends PayUAsyncTask<PayuConfig, String, ApiResponse<JSONObject>> {
    private final String TAG = this.getClass().getSimpleName();
    private final V2ApiResponseListener<ApiResponse<JSONObject>> v2ApiResponseListener;
    private final String commandName;
    private final HashMap<String, String> headerMap;

    public ApiTask(V2ApiResponseListener<ApiResponse<JSONObject>> v2ApiResponseListener, HashMap<String, String> headerMap, String commandName) {
        this.v2ApiResponseListener = v2ApiResponseListener;
        this.commandName = commandName;
        this.headerMap = headerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiResponse<JSONObject> doInBackground(PayuConfig ... params) {
        Log.d((String)this.TAG, (String)"doInBackground");
        ApiResponse<JSONObject> apiResponse = new ApiResponse<JSONObject>();
        PostData postData = new PostData();
        InputStream responseInputStream = null;
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            url = PayuUtils.getApiV2Url(payuConfig);
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + V2ApiHelper.getInstance().getApiEndPoint(this.commandName)).setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getOlwAuthHeader(this.commandName, this.headerMap)).setRequestType("application/json").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                int i;
                responseInputStream = conn.getResponseCode() == 200 ? conn.getInputStream() : conn.getErrorStream();
                apiResponse.setStatus(conn.getResponseCode());
                StringBuilder responseStringBuffer = new StringBuilder();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                apiResponse.setRawResponse(jsonResponse);
                apiResponse.setPayuResponse(jsonResponse);
                if (jsonResponse.has("status") && jsonResponse.optInt("status") == 0) {
                    postData.setCode(5052);
                    postData.setStatus("ERROR");
                    postData.setResult(jsonResponse.optString("data") != null ? jsonResponse.optString("data") : "Something went wong.");
                } else if (jsonResponse.optInt("status") == 1) {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                }
            }
        }
        catch (MalformedURLException e) {
            Log.d((String)this.TAG, (String)(" MalformedURLException" + e.getMessage()));
            postData.setCode(5022);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)(" IOException" + e.getMessage()));
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            Log.d((String)this.TAG, (String)(" IllegalArgumentException" + e.getMessage()));
            postData.setCode(5023);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)(" JSONException" + e.getMessage()));
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.d((String)this.TAG, (String)(" ArrayIndexOutOfBoundsException" + e.getMessage()));
            postData.setCode(5024);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        finally {
            if (responseInputStream != null) {
                PayuUtils.safeClose(responseInputStream);
            }
        }
        apiResponse.setPostData(postData);
        return apiResponse;
    }

    @Override
    protected void onPostExecute(ApiResponse<JSONObject> jsonObjectApiResponse) {
        super.onPostExecute(jsonObjectApiResponse);
        this.v2ApiResponseListener.onApiResponse(jsonObjectApiResponse);
    }
}

