/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Payu.v2ApiResponseParser;

import android.util.Log;
import com.payu.india.Model.ApiResponse;
import com.payu.india.Model.CardInformation;
import com.payu.india.Model.DiscountDetailsofOffers;
import com.payu.india.Model.ValidateOfferInfo;
import com.payu.india.Model.fetchConvenienceFee.Charges;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeCombinations;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeResponse;
import com.payu.india.Model.validateOffer.SKUOfferDetails;
import com.payu.india.Model.validateOffer.ValidateOfferDetails;
import com.payu.india.Payu.PayuUtils;
import com.payu.paymentparamhelper.Sku;
import com.payu.paymentparamhelper.SkuDiscountDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class V2ApiResponseParser {
    public void parseBinInfoResponse(JSONObject jsonResponse, CardInformation cardInformation) throws JSONException {
        JSONObject binsData = jsonResponse.getJSONObject("bins_data");
        JSONObject convFeeData = binsData.optJSONObject("convenienceFeeData");
        cardInformation.setIssuingBank(binsData.getString("issuing_bank"));
        cardInformation.setBin(binsData.getString("bin"));
        cardInformation.setCardCategory(binsData.getString("category").equalsIgnoreCase("debitcard") ? "DC" : "CC");
        cardInformation.setCardType(binsData.getString("card_type"));
        cardInformation.setIsZeroRedirectSupported(binsData.optInt("is_zero_redirect_supported") == 1);
        cardInformation.setIsOtpOnTheFly(binsData.optInt("is_otp_on_the_fly") == 1);
        cardInformation.setIsAtmPinCard(binsData.optString("is_atmpin_card").contentEquals("1"));
        cardInformation.setIsSiSupported(binsData.optInt("is_si_supported") == 1);
        cardInformation.setPgId(binsData.optString("pgId"));
        cardInformation.setBankCode(binsData.optString("ibiboCode"));
        cardInformation.setIsDomestic(binsData.getString("is_domestic").contentEquals("1"));
        if (convFeeData != null) {
            cardInformation.setConvenienceFee(convFeeData.optString("convenienceFee", "0"));
            cardInformation.setGst(convFeeData.optString("gst", "0"));
            cardInformation.setBinLevel(convFeeData.optBoolean("binLevel"));
        }
    }

    public void parseValidateOfferResponse(JSONObject result, ValidateOfferDetails validateOfferDetails) throws JSONException {
        JSONArray offerDetailJsonArray;
        validateOfferDetails.setAmount(PayuUtils.getDoubleValue(result, "amount"));
        validateOfferDetails.setValid(result.optBoolean("isValid"));
        if (!result.isNull("totalDiscountDetail")) {
            JSONObject totalDiscountDetail = result.getJSONObject("totalDiscountDetail");
            validateOfferDetails.setTotalCashbackDiscount(PayuUtils.getDoubleValue(totalDiscountDetail, "totalCashbackDiscount"));
            validateOfferDetails.setTotalInstantDiscount(PayuUtils.getDoubleValue(totalDiscountDetail, "totalInstantDiscount"));
            validateOfferDetails.setTotalDiscountedAmount(PayuUtils.getDoubleValue(totalDiscountDetail, "totalDiscountedAmount"));
        }
        if ((offerDetailJsonArray = result.optJSONArray("offers")) != null) {
            validateOfferDetails.setValidateOfferInfo(this.prepareOfferInfoList(offerDetailJsonArray));
        }
        validateOfferDetails.setFailureReason(PayuUtils.getStringValue(result, "failureReason"));
        if (result.optJSONObject("skusDetail") != null) {
            JSONObject skuDetails = result.optJSONObject("skusDetail");
            JSONObject skuDiscountDetailsJson = skuDetails.optJSONObject("skusDiscountDetail");
            validateOfferDetails.setTotalCashbackDiscount(PayuUtils.getDoubleValue(skuDiscountDetailsJson, "totalCashbackDiscount"));
            validateOfferDetails.setTotalInstantDiscount(PayuUtils.getDoubleValue(skuDiscountDetailsJson, "totalInstantDiscount"));
            validateOfferDetails.setTotalDiscountedAmount(PayuUtils.getDoubleValue(skuDiscountDetailsJson, "totalDiscountedAmount"));
            if (skuDetails.optJSONArray("skus") != null) {
                ArrayList<SKUOfferDetails> skuOfferDetailsList = new ArrayList<SKUOfferDetails>();
                JSONArray skus = skuDetails.optJSONArray("skus");
                for (int i = 0; skus != null && i < skus.length(); ++i) {
                    JSONObject skuJsonObject = skus.optJSONObject(i);
                    Sku sku = new Sku();
                    sku.setSkuId(skuJsonObject.optString("skuId"));
                    sku.setQuantity(skuJsonObject.optInt("quantity"));
                    sku.setSkuAmount(skuJsonObject.optString("skuAmount"));
                    sku.setName(skuJsonObject.optString("name"));
                    sku.setAutoApplyOffer(skuJsonObject.optBoolean("autoApply"));
                    SKUOfferDetails skuOfferDetails = new SKUOfferDetails();
                    JSONObject totalSkuDiscountDetails = skuJsonObject.optJSONObject("skuTotalDiscountDetail");
                    if (totalSkuDiscountDetails != null) {
                        SkuDiscountDetails skuDiscountDetails = new SkuDiscountDetails();
                        skuDiscountDetails.setInstant(PayuUtils.getDoubleValue(totalSkuDiscountDetails, "totalInstantDiscount"));
                        skuDiscountDetails.setCashBack(PayuUtils.getDoubleValue(totalSkuDiscountDetails, "totalCashbackDiscount"));
                        skuDiscountDetails.setDiscountedAmount(PayuUtils.getDoubleValue(totalSkuDiscountDetails, "totalDiscountedAmount"));
                        skuOfferDetails.setSkuDiscountDetails(skuDiscountDetails);
                    }
                    skuOfferDetails.setSku(sku);
                    skuOfferDetails.setValid(skuJsonObject.optBoolean("isValid"));
                    if (skuJsonObject.optJSONArray("offers") == null) continue;
                    JSONArray skuJofferDetailJsonArray = skuJsonObject.optJSONArray("offers");
                    if (skuJofferDetailJsonArray != null) {
                        skuOfferDetails.setValidateOfferInfoList(this.prepareOfferInfoList(skuJofferDetailJsonArray));
                    }
                    skuOfferDetailsList.add(skuOfferDetails);
                }
                validateOfferDetails.setSkuOfferDetailsList(skuOfferDetailsList);
            }
        }
        validateOfferDetails.setAutoApply(result.optBoolean("autoApply"));
    }

    private List<ValidateOfferInfo> prepareOfferInfoList(JSONArray offerDetailJsonArray) {
        ArrayList<ValidateOfferInfo> validateOfferInfoList = new ArrayList<ValidateOfferInfo>();
        for (int i = 0; i < offerDetailJsonArray.length(); ++i) {
            try {
                JSONObject offerDetailJson = offerDetailJsonArray.getJSONObject(i);
                validateOfferInfoList.add(this.prepareValidateOfferInfo(offerDetailJson));
                continue;
            }
            catch (JSONException e) {
                Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
            }
        }
        return validateOfferInfoList;
    }

    private ValidateOfferInfo prepareValidateOfferInfo(JSONObject validateInfoJsonObject) {
        ValidateOfferInfo validateOfferInfo = new ValidateOfferInfo();
        validateOfferInfo.setOfferKey(validateInfoJsonObject.optString("offerKey"));
        String offerType = validateInfoJsonObject.optString("offerType");
        validateOfferInfo.setOfferType(offerType);
        validateOfferInfo.setTitle(validateInfoJsonObject.optString("title"));
        validateOfferInfo.setDescription(validateInfoJsonObject.optString("description"));
        validateOfferInfo.setValidFrom(validateInfoJsonObject.optString("validFrom"));
        validateOfferInfo.setValidTo(validateInfoJsonObject.optString("validTo"));
        validateOfferInfo.setTnc(validateInfoJsonObject.optString("tnc"));
        validateOfferInfo.setTncLink(validateInfoJsonObject.optString("tncLink"));
        validateOfferInfo.setDiscountType(validateInfoJsonObject.optString("discountType"));
        validateOfferInfo.setOfferPercentage(validateInfoJsonObject.optString("offerPercentage"));
        validateOfferInfo.setMaxDiscountPerTxn(validateInfoJsonObject.optDouble("maxDiscountPerTxn"));
        validateOfferInfo.setMaxTxnAmount(Double.parseDouble(Objects.requireNonNull(validateInfoJsonObject.opt("maxTxnAmount")).toString()));
        validateOfferInfo.setMinTxnAmount(Double.parseDouble(Objects.requireNonNull(validateInfoJsonObject.opt("minTxnAmount")).toString()));
        validateOfferInfo.setStatus(validateInfoJsonObject.optString("status"));
        validateOfferInfo.setIsNoCostEmi(validateInfoJsonObject.optBoolean("isNce"));
        validateOfferInfo.setValid(validateInfoJsonObject.optBoolean("isValid"));
        validateOfferInfo.setOfferCategory(validateInfoJsonObject.optString("offerCategory"));
        validateOfferInfo.setSkuOffer(validateInfoJsonObject.optBoolean("isSkuOffer"));
        validateOfferInfo.setAllPaymentMethodsAvailable(validateInfoJsonObject.optBoolean("isAllPaymentMethodsAvailable"));
        validateOfferInfo.setDisallowTransactionInvalidOffer(validateInfoJsonObject.optBoolean("disallowTransactionInvalidOffer"));
        validateOfferInfo.setAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, "amount"));
        validateOfferInfo.setDiscount(PayuUtils.getDoubleValue(validateInfoJsonObject, "discount"));
        validateOfferInfo.setDiscountedAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, "discountedAmount"));
        DiscountDetailsofOffers discountDetailsofOffers = new DiscountDetailsofOffers();
        discountDetailsofOffers.setDiscount(PayuUtils.getDoubleValue(validateInfoJsonObject, "discount"));
        discountDetailsofOffers.setDiscountType(offerType);
        discountDetailsofOffers.setDiscountedAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, "discountedAmount"));
        validateOfferInfo.setDiscountDetails(discountDetailsofOffers);
        return validateOfferInfo;
    }

    public void parseFetchConvFeeResponse(JSONObject jsonObject, ApiResponse<FetchConvFeeResponse> apiResponse) {
        JSONObject data = jsonObject.optJSONObject("data");
        FetchConvFeeResponse fetchConvFeeResponse = new FetchConvFeeResponse();
        HashMap<String, FetchConvFeeCombinations> convFeeMap = this.parseFetchConvFeeRespToMap(data);
        if (convFeeMap != null) {
            fetchConvFeeResponse.setConvFeeChargesMap(convFeeMap);
        }
        apiResponse.setPayuResponse(fetchConvFeeResponse);
    }

    public HashMap<String, FetchConvFeeCombinations> parseFetchConvFeeRespToMap(JSONObject data) {
        JSONObject combinationsData;
        if (data != null && (combinationsData = data.optJSONObject("combinations")) != null) {
            String requestId = data.optString("requestUUID");
            Iterator keysIterator = combinationsData.keys();
            HashMap<String, FetchConvFeeCombinations> convFeeMap = new HashMap<String, FetchConvFeeCombinations>();
            while (keysIterator.hasNext()) {
                String combinationKey = (String)keysIterator.next();
                JSONObject bankCodeJson = combinationsData.optJSONObject(combinationKey);
                if (bankCodeJson == null) continue;
                JSONArray chargesJson = bankCodeJson.optJSONArray("charges");
                String combinationUUID = bankCodeJson.optString("combinationUUID");
                FetchConvFeeCombinations feeCombinations = new FetchConvFeeCombinations();
                feeCombinations.setCombinationKey(combinationKey);
                feeCombinations.setCombinationUUID(combinationUUID);
                feeCombinations.setRequestUuid(requestId);
                ArrayList<Charges> chargesArrayList = new ArrayList<Charges>();
                for (int i = 0; i < Objects.requireNonNull(chargesJson).length(); ++i) {
                    JSONObject chargeJsonObject = chargesJson.optJSONObject(i);
                    Charges charges = new Charges();
                    String chargeUuid = chargeJsonObject.optString("chargeUUID");
                    charges.setChargeUuid(chargeUuid);
                    String chargeName = chargeJsonObject.optString("chargeName");
                    charges.setChargeName(chargeName);
                    double baseFee = chargeJsonObject.optDouble("baseFee");
                    charges.setBaseFee(baseFee);
                    double taxAmt = chargeJsonObject.optDouble("taxAmount");
                    charges.setTaxAmount(taxAmt);
                    String ruleId = chargeJsonObject.optString("ruleId");
                    charges.setRuleId(ruleId);
                    chargesArrayList.add(charges);
                    feeCombinations.setCharges(chargesArrayList);
                }
                convFeeMap.put(combinationKey, feeCombinations);
            }
            return convFeeMap;
        }
        return null;
    }
}

