package com.payu.india.Tasks;

import android.util.Log;

import com.payu.india.Interfaces.GlobalVaultListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.QuickPay.QuickPaySavedOption;
import com.payu.india.Model.QuickPay.RecommendedOptions;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

import javax.net.ssl.HttpsURLConnection;

/**
 * This class allows us to perform background operations for Fetch Global Vault list Request and publish the results.
 */
public class QuickPayTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private final String TAG = this.getClass().getSimpleName();

    private final GlobalVaultListener globalVaultListener;

    /**
     * Class constructor specifying number of objects to create.
     *
     * @param globalVaultListener globalVault response Listener
     */
    public QuickPayTask(GlobalVaultListener globalVaultListener) {
        this.globalVaultListener = globalVaultListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        Log.d(TAG, "doInBackground");

        //TODO: Since the backend is not yet ready. Data is being captured as String. This
        // code will be optimised with live testing

        String payuResponse = "";
        PayuResponse quickPayResponse = new PayuResponse();
        PostData postData = new PostData();
        InputStream responseInputStream = null;


        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];
            // set the environment
            //Todo: To be changed later
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_APIV2_URL);
                    break;
                default:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
            }

            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).
                    setURL(url + PayuConstants.QUICK_PAY_API_ENDPOINT).setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader(PayuConstants.PAYU_QUICKPAYEVENT)).
                    setRequestType(PayuConstants.REQUEST_APPLICATION_JSON).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
//
            if (null != conn) {
                responseInputStream = conn.getInputStream();
                StringBuilder responseStringBuffer = new StringBuilder();
                byte[] byteContainer = new byte[1024];
                for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }

                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                JSONObject result = jsonResponse.getJSONObject(PayuConstants.P_RESULT);
                JSONObject savedPaymentOptions = result.getJSONObject(PayuConstants.PAYU_SAVEDOPTIONS);
                ArrayList<QuickPaySavedOption> savedOptionArrayList = new ArrayList<>();
                if (isJSONObjectAvailableForKey(savedPaymentOptions, PayuConstants.PAYU_CC))
                    getSavedOption(savedPaymentOptions.getJSONArray(PayuConstants.PAYU_CC), savedOptionArrayList, PayuConstants.PAYU_CC);
                if (isJSONObjectAvailableForKey(savedPaymentOptions, PayuConstants.PAYU_DC))
                    getSavedOption(savedPaymentOptions.getJSONArray(PayuConstants.PAYU_DC), savedOptionArrayList, PayuConstants.PAYU_DC);
                if (isJSONObjectAvailableForKey(savedPaymentOptions, PayuConstants.PAYU_NB))
                    getSavedOption(savedPaymentOptions.getJSONArray(PayuConstants.PAYU_NB), savedOptionArrayList, PayuConstants.PAYU_NB);
                if (isJSONObjectAvailableForKey(savedPaymentOptions, PayuConstants.UPI))
                    getSavedOption(savedPaymentOptions.getJSONArray(PayuConstants.UPI), savedOptionArrayList, PayuConstants.UPI);
                if (isJSONObjectAvailableForKey(savedPaymentOptions, PayuConstants.BNPL.toLowerCase()))
                    getSavedOption(savedPaymentOptions.getJSONArray(PayuConstants.BNPL.toLowerCase()), savedOptionArrayList, PayuConstants.BNPL.toLowerCase());
                if (isJSONObjectAvailableForKey(savedPaymentOptions, PayuConstants.PAYU_CASH_CARD))
                    getSavedOption(savedPaymentOptions.getJSONArray(PayuConstants.PAYU_CASH_CARD), savedOptionArrayList, PayuConstants.PAYU_CASH_CARD);
                quickPayResponse.setSavedOption(savedOptionArrayList);
                if (result.has(PayuConstants.GV_TILES)) {
                    JSONArray tiles = result.getJSONArray(PayuConstants.GV_TILES);
                    ArrayList<RecommendedOptions> recommendedOptions = new ArrayList<>();
                    quickPayResponse.setRecommendedOptions(getRecommendedOptions(tiles, recommendedOptions));
                }
                Log.d(TAG, " payuResponse successfully parsed");

                if (jsonResponse.has(PayuConstants.STATUS) && jsonResponse.getString(PayuConstants.STATUS).contentEquals("0")) {
                    postData = new PostData();
                    postData.setCode(PayuErrors.INVALID_HASH);
                    postData.setStatus(PayuConstants.ERROR);
                    postData.setResult(jsonResponse.getString(PayuConstants.MSG));
                } else {
                    postData.setCode(PayuErrors.NO_ERROR);
                    // Result status should be success
                    postData.setResult(PayuErrors.DETAILS_FETCHED_SUCCESSFULLY);
                    postData.setStatus(PayuConstants.SUCCESS);
                }
                PayuUtils.safeClose(responseInputStream);
            }
        } catch (MalformedURLException e) {
            Log.d(TAG, " MalformedURLException" + e.getMessage());
            postData.setCode(PayuErrors.MALFORMED_URL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, " MalformedURLException" + e.getMessage());
            postData.setCode(PayuErrors.IO_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (JSONException e) {
            Log.d(TAG, " JSONException" + e.getMessage());
            postData.setCode(PayuErrors.JSON_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } finally {
            if (responseInputStream != null)
                PayuUtils.safeClose(responseInputStream);
        }

        if (isCancelled()) {
            return null;
        } else {
            quickPayResponse.setResponseStatus(postData);
            return quickPayResponse;
        }
    }


    private void getSavedOption(JSONArray savedPaymentOptionsArray, ArrayList<QuickPaySavedOption> savedOptionArrayList, String key) {
        try {
            for (int i = 0; i < savedPaymentOptionsArray.length(); i++) {
                QuickPaySavedOption savedOption = new QuickPaySavedOption();
                JSONObject paymentObject = savedPaymentOptionsArray.getJSONObject(i);
                int pgId = paymentObject.optInt(PayuConstants.PG_ID);
                savedOption.setPgId(String.valueOf(pgId));
                savedOption.setPgTitle(paymentObject.optString(PayuConstants.PAYU_PGTITLE));
                savedOption.setPgDetails(paymentObject.optString(PayuConstants.PAYU_PGDETAILS));
                savedOption.setIbiboCode(paymentObject.optString(PayuConstants.IBIBOCODE));
                savedOption.setUserCredential(paymentObject.optString(PayuConstants.GV_USER_CREDENTIALS));
                savedOption.setPgDisplay(paymentObject.optBoolean(PayuConstants.PAYU_PGDISPLAY));
                savedOption.setPgUP(paymentObject.optBoolean(PayuConstants.PAYU_PGUP));
                savedOption.setTokenTxn(paymentObject.optBoolean(PayuConstants.PAYU_IS_TOKENTXN));
                savedOption.setPhoneNumber(paymentObject.optString(PayuConstants.PAYU_PHONE_NUMBER));
                savedOption.setPaymentType(key);
                savedOptionArrayList.add(savedOption);
            }
        } catch (JSONException e) {
            Log.d(TAG, " JSONException" + e.getMessage());
        }

    }


    private ArrayList<RecommendedOptions> getRecommendedOptions(JSONArray jsonArray, ArrayList<RecommendedOptions> list) {
        for (int i = 0; i < jsonArray.length(); i++) {
            try {
                RecommendedOptions recommendedOptions = new RecommendedOptions();
                JSONObject recommendedJsonObject = jsonArray.getJSONObject(i);
                recommendedOptions.setPaymode(PayuUtils.getPaymentTypeValue((recommendedJsonObject.optString(PayuConstants.GV_PAYMODE)).toLowerCase()));
                recommendedOptions.setIbiboCode(recommendedJsonObject.optString(PayuConstants.IBIBOCODE));
                recommendedOptions.setAction(recommendedJsonObject.optString(PayuConstants.PAYU_ACTION));
                recommendedOptions.setTag(recommendedJsonObject.optString(PayuConstants.GV_TAG));
                recommendedOptions.setUserInfo(recommendedJsonObject.optString(PayuConstants.GV_USER_INFO));
                recommendedOptions.setPaymentInfo(recommendedJsonObject.optString(PayuConstants.GV_PAYMENT_INFO));
                recommendedOptions.setEligibilityCheck(recommendedJsonObject.optBoolean(PayuConstants.GV_ELIGIBILITY_CHECK));
                recommendedOptions.setEligibleAmount(recommendedJsonObject.optString(PayuConstants.GV_ELIGIBILITY_AMOUNT));
                recommendedOptions.setTitle(recommendedJsonObject.optString(PayuConstants.TITLE));
                recommendedOptions.setMsg(recommendedJsonObject.optString(PayuConstants.MSG));
                list.add(recommendedOptions);
            } catch (JSONException e) {
                Log.d(TAG, " JSONException" + e.getMessage());
            }
        }
        return list;
    }

    private boolean isJSONObjectAvailableForKey(JSONObject paymentOptions, String key) {
        return paymentOptions.has(key) && paymentOptions.optJSONArray(key) != null && paymentOptions.optJSONArray(key).length() != 0;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        Log.d(TAG, " onPostExecute " + payuResponse);
        if (!isCancelled()) {
            Log.d(TAG, " onPostExecute QuickPayTask not cancelled" + payuResponse);
            globalVaultListener.onQuickPayResponse(payuResponse);
        }
    }
}

