package com.payu.india.Tasks;

import static com.payu.india.Payu.PayuConstants.CLIENTTYPE_KEY;
import static com.payu.india.Payu.PayuConstants.CLIENTTYPE_VALUE;
import static com.payu.india.Payu.PayuConstants.PAYU_CONTENT_TYPE;
import static com.payu.india.Payu.PayuConstants.PAYU_HTTPSTATUSCODE;
import static com.payu.india.Payu.PayuConstants.PAYU_RESPONSECODE;
import static com.payu.india.Payu.PayuConstants.PAYU_RESPONSEMESSAGE;
import static com.payu.india.Payu.PayuConstants.REQUEST_APPLICATION_JSON;
import static com.payu.india.Payu.PayuConstants.UUID;

import android.util.Log;

import com.payu.india.Interfaces.GlobalVaultListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import com.payu.india.Payu.V2ApiHelper;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;

import javax.net.ssl.HttpsURLConnection;

/**
 * This class allows us to perform background operations for Send Global Vault OTP Request and publish the results.
 */
public class GlobalVaultSendOTPTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private final String TAG = getClass().getSimpleName();

    private final GlobalVaultListener globalVaultListener;

    /**
     * Class constructor specifying number of objects to create.
     *
     * @param globalVaultListener QuickPay OTP response listener
     */
    public GlobalVaultSendOTPTask(GlobalVaultListener globalVaultListener) {
        this.globalVaultListener = globalVaultListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        Log.d(TAG, "doInBackground");
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_APIV2_URL);
                    break;
                default:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
            }

            HashMap<String, String> headerMap = getHeaderHashMap(V2ApiHelper.getInstance().getAuthHeader(PayuConstants.PAYU_GV_SEND_OTP));


            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST)
                    .setURL(url + PayuConstants.GLOBALVAULT_SENDOTP_API_ENDPOINT)
                    .setPostData(payuConfig.getData()).setHeaders(headerMap)
                    .setRequestType(PayuConstants.REQUEST_APPLICATION_CHAR_JSON)
                    .build();

            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);

            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                if (response.getInt(PAYU_HTTPSTATUSCODE) == 200) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                    postData.setResult(response.getString(UUID));
                } else {
                    postData.setCode(response.getInt(PAYU_RESPONSECODE));
                    postData.setStatus(PayuConstants.ERROR);
                    postData.setResult(response.getString(PAYU_RESPONSEMESSAGE));

                }
            }
        } catch (MalformedURLException e) {
            Log.d(TAG, " MalformedURLException" + e.getMessage());
            postData.setCode(PayuErrors.MALFORMED_URL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (ProtocolException e) {
            Log.d(TAG, " ProtocolException " + e.getMessage());
            postData.setCode(PayuErrors.PROTOCOL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, " IOException " + e.getMessage());
            postData.setCode(PayuErrors.IO_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (JSONException e) {
            Log.d(TAG, " JSONException " + e.getMessage());
            postData.setCode(PayuErrors.JSON_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        }


        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    /**
     * Method to construct request Headers
     *
     * @return headers as Map
     */
    private HashMap<String, String> getHeaderHashMap(HashMap<String, String> headerMap) {
        headerMap.put(CLIENTTYPE_KEY, CLIENTTYPE_VALUE);
        headerMap.put(PAYU_CONTENT_TYPE, REQUEST_APPLICATION_JSON);
        return headerMap;
    }


    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        Log.d(TAG, " onPostExecute ");
        globalVaultListener.onQuickPayResponse(payuResponse);
    }
}

