//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Tasks;

import static com.payu.india.Payu.PayuConstants.PAYU_IFSC_BANK_NAME_MAPPING;

import android.os.AsyncTask;
import android.util.Log;

import com.payu.india.Interfaces.CheckoutDetailsListener;
import com.payu.india.Model.Bnpl;
import com.payu.india.Model.Emi;
import com.payu.india.Model.IfscMappingDetails;
import com.payu.india.Model.MerchantInfo;
import com.payu.india.Model.MerchantParamInfo;
import com.payu.india.Model.PayUEmiTenures;
import com.payu.india.Model.PaymentDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuOffer;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.TaxSpecification;
import com.payu.india.Model.Upi;
import com.payu.india.Model.UpiApp;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import javax.net.ssl.HttpsURLConnection;


/**
 * Async task which takes care of Getting checkout details for a merchant
 * Takes PayuConfig as input and sends PayuResponse to the calling activity
 * Activity which calls {@link GetPaymentInstrumentTask} should implement {@link CheckoutDetailsListener}
 */
public class GetPaymentInstrumentTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private final CheckoutDetailsListener mCheckoutDetailsListener;

    public GetPaymentInstrumentTask(CheckoutDetailsListener checkoutDetailsListener) {
        this.mCheckoutDetailsListener = checkoutDetailsListener;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {

        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        InputStream responseInputStream = null;
        try {
            URL url;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                case PayuConstants.BIZCHECKOUT_TEST_ENV:
                    url = new URL(PayuConstants.BIZ_CHECKOUT_TEST_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }

            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {

                responseInputStream = conn.getInputStream();

                StringBuilder responseStringBuffer = new StringBuilder();
                byte[] byteContainer = new byte[1024];
                for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }

                JSONObject resp = new JSONObject(responseStringBuffer.toString());

                payuResponse.setRawResponse(resp);

                if (resp.has(PayuConstants.DETAILS) && resp.optJSONObject(PayuConstants.DETAILS) != null) {

                    JSONObject details = resp.getJSONObject(PayuConstants.DETAILS);
                    JSONArray offersArray = details.optJSONArray(PayuConstants.OFFERS);
                    if (offersArray != null && offersArray.length() != 0) {
                        ArrayList<PayuOffer> offersList = new ArrayList<>();
                        for (int i = 0; i < offersArray.length(); i++) {
                            JSONObject offerObject = offersArray.getJSONObject(i);
                            PayuOffer payuOffer = new PayuOffer();
                            payuOffer.setId(offerObject.optString(PayuConstants.ID));
                            payuOffer.setTitle(offerObject.optString(PayuConstants.TITLE));
                            payuOffer.setDescription(offerObject.optString(PayuConstants.DESCRIPTION));
                            payuOffer.setMinAmount(offerObject.optString(PayuConstants.PAYU_MIN_AMOUNT));
                            payuOffer.setDiscount(offerObject.optString(PayuConstants.DISCOUNT));
                            payuOffer.setDiscountUnit(offerObject.optString(PayuConstants.DISCOUNT_UNIT));
                            payuOffer.setOfferType(offerObject.optString(PayuConstants.OFFER_TYPE));
                            payuOffer.setValidOnDays(offerObject.optString(PayuConstants.VALID_ON_DAYS));
                            payuOffer.setOfferKey("@" + offerObject.optString(PayuConstants.ID));
                            offersList.add(payuOffer);
                        }
                        payuResponse.setOfferDetailsList(offersList);
                    }

                    /*
                    Parsing Down Info Object
                     */
                    JSONObject downInfoObject = details.optJSONObject(PayuConstants.DOWN_INFO);
                    if (downInfoObject != null && downInfoObject.length() != 0) {
                        JSONArray issuingBanks = downInfoObject.optJSONArray(PayuConstants.ISSUING_BANKS);
                        if (issuingBanks != null && issuingBanks.length() != 0) {
                            ArrayList<String> issuingBanksList = new ArrayList<>();
                            for (int i = 0; i < issuingBanks.length(); i++) {
                                if (issuingBanks.optString(i) != null && !issuingBanks.getString(i).isEmpty()) {
                                    issuingBanksList.add(issuingBanks.getString(i));
                                }
                            }
                            payuResponse.setDownIssuingBanks(issuingBanksList);
                        }
                    }

                    JSONObject configObject = details.optJSONObject(PayuConstants.CONFIG);

                     /*
                    Parsing Merchant Info Object
                     */
                    ArrayList<String> threedsBankList = new ArrayList<>();
                    MerchantInfo merchantInfo = new MerchantInfo();
                    JSONObject merchant = details.optJSONObject(PayuConstants.P_MERCHANT);
                    if (merchant != null && merchant.length() != 0) {
                        if (merchant.optString(PayuConstants.LOGO) != null && !(merchant.optString(PayuConstants.LOGO).equalsIgnoreCase("null")))
                            merchantInfo.setLogo(merchant.optString(PayuConstants.LOGO));
                        merchantInfo.setDisplayName(merchant.optString(PayuConstants.DISPLAYNAME));
                        merchantInfo.setWalletIdentifier(merchant.optString(PayuConstants.WALLET_IDENTIFIER));
                        String retryCount = merchant.optString(PayuConstants.RETRYALLOWED);
                        if (retryCount != null && !retryCount.isEmpty())
                            merchantInfo.setRetryCount(Integer.parseInt(retryCount));
                        JSONObject ifscMappingJson = merchant.optJSONObject(PAYU_IFSC_BANK_NAME_MAPPING);
                        if (ifscMappingJson != null) {
                            Iterator<String> keys = ifscMappingJson.keys();
                            List<IfscMappingDetails> ifscMappingDetailsList = new ArrayList<>();
                            while (keys.hasNext()) {
                                String key = keys.next();
                                JSONObject bankJson = ifscMappingJson.optJSONObject(key);
                                if (bankJson != null) {
                                    IfscMappingDetails ifscMappingDetails = new IfscMappingDetails();
                                    ifscMappingDetails.setIfscCode(key);
                                    ifscMappingDetails.setBankName(bankJson.optString(PayuConstants.P_NAME));
                                    ifscMappingDetails.setImageUrl(bankJson.optString(PayuConstants.PAYMENT_OPTION_ASSET_URL));
                                    ifscMappingDetails.setImageUpdateOn(bankJson.optString(PayuConstants.PAYMENT_OPTION_ASSET_UPDATED_ON));
                                    ifscMappingDetails.setIbiboCode(bankJson.optString(PayuConstants.IBIBOCODE));
                                    ifscMappingDetailsList.add(ifscMappingDetails);
                                }
                            }
                            merchantInfo.setIfscMappingDetails(ifscMappingDetailsList);
                        }
                        JSONObject merchantParamObj = merchant.optJSONObject(PayuConstants.MERCHANT_PARAM);
                        MerchantParamInfo paramInfo = new MerchantParamInfo();
                        if (merchantParamObj != null && merchantParamObj.has(PayuConstants.PAYU_IS_ADS_ENABLE)) {
                            paramInfo.setAdsEnabled(merchantParamObj.optInt(PayuConstants.PAYU_IS_ADS_ENABLE) == 1);
                        }
                        if (configObject != null && configObject.has(PayuConstants.PAYU_IS_QUICKPAY_ENABLE)) {
                            paramInfo.setQuickPayEnabled(configObject.optBoolean(PayuConstants.PAYU_IS_QUICKPAY_ENABLE));
                        }
                        if (configObject != null && configObject.has(PayuConstants.DEVICE_FP)) {
                            paramInfo.setDeviceIdEnabled(configObject.optBoolean(PayuConstants.DEVICE_FP));
                        }
                        if (configObject != null && configObject.has(PayuConstants.PAYU_ENABLE_INTERNAL_3DSS))
                            paramInfo.setEnableInternal3DSS(configObject.optBoolean(PayuConstants.PAYU_ENABLE_INTERNAL_3DSS));
                        if (configObject != null && configObject.has(PayuConstants.PAYU_INTERNATIONAL_ON_3DSS))
                            paramInfo.setInternationalOn3DSS(configObject.optBoolean(PayuConstants.PAYU_INTERNATIONAL_ON_3DSS));
                        if (configObject != null && configObject.has(PayuConstants.PAYU_ENABLE_3DSSDK))
                            paramInfo.setEnable3dsSDK(configObject.optBoolean(PayuConstants.PAYU_ENABLE_3DSSDK));
                        if (configObject != null && configObject.has(PayuConstants.PAYU_3DS_SUPPORTED_BANK_LIST)) {
                            threedsBankList.addAll(Arrays.asList(configObject.getString(PayuConstants.PAYU_3DS_SUPPORTED_BANK_LIST).split("\\|")));
                            paramInfo.setThreedsBankList(threedsBankList);
                        }
                        if (configObject != null && configObject.has(PayuConstants.PAYU_IS_OFFER_ENABLED)) {
                            paramInfo.setOfferEnabled(configObject.optBoolean(PayuConstants.PAYU_IS_OFFER_ENABLED));
                        }

                        if (configObject != null && configObject.has(PayuConstants.PAYU_IS_QUICK_PAY_BT_SHEET_ENABLED)) {
                            paramInfo.setQuickPayBottomSheetEnabled(configObject.optBoolean(PayuConstants.PAYU_IS_QUICK_PAY_BT_SHEET_ENABLED));
                        }

                        if (configObject != null && configObject.has(PayuConstants.PAYU_IS_NFC_ENABLED)) {
                            paramInfo.setNfcEnabled(configObject.optBoolean(PayuConstants.PAYU_IS_NFC_ENABLED));
                        }

                        if (configObject != null && configObject.has(PayuConstants.PAYU_UPI_APPS)) {
                            JSONArray upiApps = configObject.optJSONArray(PayuConstants.PAYU_UPI_APPS);
                            if (upiApps != null && upiApps.length() != 0) {
                                ArrayList<UpiApp> upiApp = new ArrayList<>();
                                for (int i = 0; i < upiApps.length(); i++) {
                                    JSONObject upiAppObject = null;
                                    upiAppObject = upiApps.getJSONObject(i);
                                    UpiApp payuOffer = new UpiApp();
                                    payuOffer.setHandlers(upiAppObject.optString(PayuConstants.PAYU_HANDLERS));
                                    payuOffer.setAppName(upiAppObject.optString(PayuConstants.PAYU_APP_NAME));
                                    payuOffer.setAndroidBundleIdentifier(upiAppObject.optString(PayuConstants.PAYU_ANDROID_BUNDLE_IDENTIFIER));
                                    upiApp.add(payuOffer);
                                }
                                paramInfo.setUpiApps(upiApp);
                            }
                        }
                        if (configObject != null && configObject.has(PayuConstants.PAYU_UPI_SI_APPS)) {
                            ArrayList<String> upiSiAppsList = new ArrayList<>(Arrays.asList(configObject.getString(PayuConstants.PAYU_UPI_SI_APPS).split(",")));
                            paramInfo.setUpiSIApps(upiSiAppsList);
                        }

                        if (configObject != null && configObject.has(PayuConstants.PAYU_CUSTOMER_REVENUE_ENABLED)) {
                            paramInfo.setCustomerRevenueEnabled(configObject.optBoolean(PayuConstants.PAYU_CUSTOMER_REVENUE_ENABLED));
                        }



                        if (configObject != null && configObject.has(PayuConstants.PAYU_OPGSP_MERCHANT)) {
                            String opgsp = configObject.optString(PayuConstants.PAYU_OPGSP_MERCHANT);
                            paramInfo.setOpgspMerchant(
                                    opgsp != null && !opgsp.isEmpty() && !(opgsp.equalsIgnoreCase("null"))
                            );
                        }

                        merchantInfo.setMerchantParamInfo(paramInfo);

                        if (merchant.optJSONArray(PayuConstants.MINKASUIBIBOCODES) != null)
                            merchantInfo.setOneClickPayBankCodes(getArrayListFromJsonArray(merchant.getJSONArray(PayuConstants.MINKASUIBIBOCODES)));
                        payuResponse.setMerchantInfo(merchantInfo);
                    }

                    /*
                    Parsing Config Object
                     */
                    if (configObject != null) {
                        TaxSpecification taxSpecification = new TaxSpecification();
                        taxSpecification.setCcTaxValue(getTaxFromConfigObject(configObject, PayuConstants.PAYU_CC));
                        taxSpecification.setDcTaxValue(getTaxFromConfigObject(configObject, PayuConstants.PAYU_DC));
                        taxSpecification.setNbTaxValue(getTaxFromConfigObject(configObject, PayuConstants.PAYU_NB));
                        taxSpecification.setUpiTaxValue(getTaxFromConfigObject(configObject, PayuConstants.UPI));
                        taxSpecification.setEmiTaxValue(getTaxFromConfigObject(configObject, PayuConstants.EMI_IN_RESPONSE));
                        taxSpecification.setCashTaxValue(getTaxFromConfigObject(configObject, PayuConstants.PAYU_CASH));
                        taxSpecification.setEnachTaxValue(getTaxFromConfigObject(configObject, PayuConstants.ENACH));
                        taxSpecification.setLazypayTaxValue(getTaxFromConfigObject(configObject, PayuConstants.LAZYPAY));
                        taxSpecification.setSiTaxValue(getTaxFromConfigObject(configObject, PayuConstants.PAYU_SI));
                        taxSpecification.setNeftRtgsTaxValue(getTaxFromConfigObject(configObject, PayuConstants.PAYU_NEFTRTGS));
                        taxSpecification.setMealCardTaxValue(getTaxFromConfigObject(configObject, PayuConstants.MC));
                        taxSpecification.setBnplTaxValue(getTaxFromConfigObject(configObject, PayuConstants.P_BNPL));
                        payuResponse.setTaxSpecification(taxSpecification);
                    }

                    JSONObject paymentOptions = details.optJSONObject(PayuConstants.PAYMENT_OPTIONS);
                    if (paymentOptions != null && paymentOptions.length() > 0) {
                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.PAYU_CC)) {
                            payuResponse.setCreditCard(prepareListWithKeyData(details, PayuConstants.PAYU_CC));
                        }

                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.PAYU_DC)) {
                            payuResponse.setDebitCard(prepareListWithKeyData(details, PayuConstants.PAYU_DC));
                        }

                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.PAYU_NB)) {
                            payuResponse.setNetBanks(prepareListWithKeyData(details, PayuConstants.PAYU_NB));
                        }

                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.ENACH)) {
                            ArrayList<PaymentDetails> nbSiList = prepareListWithKeyData(details, PayuConstants.ENACH);
                            payuResponse.setSiBankList(nbSiList);
                        }

                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.PAYU_SI)) {
                            ArrayList<PaymentDetails> siList = prepareListWithKeyData(details, PayuConstants.PAYU_SI);
                            payuResponse.setStandingInstructions(siList);
                        }
                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.PAYU_NEFTRTGS)) {
                            ArrayList<PaymentDetails> nfetrtgsList = prepareListWithKeyData(details, PayuConstants.PAYU_NEFTRTGS);
                            payuResponse.setNeftRtgs(nfetrtgsList);
                        }

                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.PAYU_CASH)) {
                            ArrayList<PaymentDetails> walletList = prepareListWithKeyData(details, PayuConstants.PAYU_CASH);
                            PaymentDetails paymentDetails = getPhonePeIntentFromList(walletList);
                            if (paymentDetails != null)
                                payuResponse.setPhonePe(paymentDetails);
                            payuResponse.setCashCard(walletList);
                        }

                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.IVR)) {
                            payuResponse.setIvr(prepareListWithKeyData(details, PayuConstants.IVR));
                        }

                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.IVRDC)) {
                            payuResponse.setIvrdc(prepareListWithKeyData(details, PayuConstants.IVRDC));
                        }

                        if (paymentOptions.has(PayuConstants.UPI) && paymentOptions.optJSONObject(PayuConstants.UPI) != null &&
                                paymentOptions.optJSONObject(PayuConstants.UPI).optJSONArray(PayuConstants.PAYU_ALL) != null) {
                            JSONArray upiArray = paymentOptions.getJSONObject(PayuConstants.UPI).getJSONArray(PayuConstants.PAYU_ALL);
                            for (int i = 0; i < upiArray.length(); i++) {
                                JSONObject upiObject = upiArray.getJSONObject(i);
                                if (upiObject.optString(PayuConstants.IBIBOCODE).equalsIgnoreCase(PayuConstants.UPI)) {
                                    Upi upi = getUpi(offersArray, upiObject);
                                    upi.setBankDown(getBankDownStatus(downInfoObject, PayuConstants.UPI, PayuConstants.UPI));
                                    payuResponse.setUpi(upi);
                                } else if (upiObject.optString(PayuConstants.IBIBOCODE).equalsIgnoreCase(PayuConstants.UPITPV)) {
                                    Upi upi = getUpi(offersArray, upiObject);
                                    upi.setBankDown(getBankDownStatus(downInfoObject, PayuConstants.UPI, PayuConstants.UPITPV));
                                    payuResponse.setUpi(upi);
                                } else if (upiObject.optString(PayuConstants.IBIBOCODE).equalsIgnoreCase(PayuConstants.INTTPV)) {
                                    Upi upi = getUpi(offersArray, upiObject);
                                    upi.setBankDown(getBankDownStatus(downInfoObject, PayuConstants.UPI, PayuConstants.INTTPV));
                                    payuResponse.setGenericIntent(upi);
                                } else if (upiObject.optString(PayuConstants.IBIBOCODE).equalsIgnoreCase(PayuConstants.TEZOMNI)) {
                                    Upi upi = getUpi(offersArray, upiObject);
                                    upi.setBankDown(getBankDownStatus(downInfoObject, PayuConstants.UPI, PayuConstants.TEZOMNI));
                                    payuResponse.setGoogleTezOmni(upi);
                                } else if (upiObject.optString(PayuConstants.IBIBOCODE).equalsIgnoreCase(PayuConstants.TEZ)) {
                                    Upi upi = getUpi(offersArray, upiObject);
                                    upi.setBankDown(getBankDownStatus(downInfoObject, PayuConstants.UPI, PayuConstants.TEZ));
                                    payuResponse.setGoogleTez(upi);
                                } else if (upiObject.optString(PayuConstants.IBIBOCODE).equalsIgnoreCase(PayuConstants.UPI_INTENT)) {
                                    Upi upi = getUpi(offersArray, upiObject);
                                    upi.setBankDown(getBankDownStatus(downInfoObject, PayuConstants.UPI, PayuConstants.UPI_INTENT));
                                    payuResponse.setGenericIntent(upi);
                                }
                            }


                            JSONObject siDetails = paymentOptions.getJSONObject(PayuConstants.UPI).optJSONObject(PayuConstants.PAYU_SI);
                            if (siDetails != null) {
                                updateSiApps(siDetails, payuResponse);
                            }
                        }

                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.PAYU_UPI_OTM)) {
                            JSONArray upiArray = paymentOptions.getJSONArray(PayuConstants.PAYU_UPI_OTM);
                            for (int i = 0; i < upiArray.length(); i++) {
                                JSONObject upiObject = upiArray.getJSONObject(i);
                                if (upiObject.optString(PayuConstants.IBIBOCODE).equalsIgnoreCase(PayuConstants.INTOTM)) {
                                    payuResponse.setIsIntentAvailableForOtm(true);
                                    Upi upi = getUpi(offersArray, upiObject);
                                    upi.setBankDown(getBankDownStatus(downInfoObject, PayuConstants.PAYU_UPI_OTM, PayuConstants.INTOTM));
                                    payuResponse.setGenericIntent(upi);
                                } else if (upiObject.optString(PayuConstants.IBIBOCODE).equalsIgnoreCase(PayuConstants.UPIOTM)) {
                                    payuResponse.setIsUpiAvailableForOtm(true);
                                    Upi upi = getUpi(offersArray, upiObject);
                                    upi.setBankDown(getBankDownStatus(downInfoObject, PayuConstants.PAYU_UPI_OTM, PayuConstants.UPIOTM));
                                    payuResponse.setUpi(upi);
                                }
                                if (upiObject.optJSONArray(PayuConstants.UPI_SI_APPS) != null || upiObject.optJSONArray(PayuConstants.UPI_SI_HANDLES) != null) {
                                    updateSiApps(upiObject, payuResponse);
                                }
                            }
                        }

                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.EMI_IN_RESPONSE)) {
                            ArrayList<Emi> ccemiList = getEmiList(details, PayuConstants.PAYU_CC);
                            if (ccemiList != null && !ccemiList.isEmpty()) {
                                payuResponse.setCcemi(ccemiList);
                            }
                            ArrayList<Emi> dcemiList = getEmiList(details, PayuConstants.PAYU_DC);
                            if (dcemiList != null && !dcemiList.isEmpty()) {
                                payuResponse.setDcemi(dcemiList);
                            }

                            ArrayList<Emi> cardlessemiList = new ArrayList<>();
                            ArrayList<Emi> otheremiList = getEmiList(details, PayuConstants.PAYU_OTHER);
                            if (otheremiList != null && !otheremiList.isEmpty())
                                cardlessemiList.addAll(otheremiList);

                            ArrayList<Emi> cardlessList = getEmiList(details, PayuConstants.PAYU_CARDLESS);
                            if (cardlessList != null && !cardlessList.isEmpty())
                                cardlessemiList.addAll(cardlessList);

                            if (!cardlessemiList.isEmpty()) {
                                payuResponse.setCardlessemi(cardlessemiList);
                            }
                        }

                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.LAZYPAY)) {
                            payuResponse.setLazyPay(prepareListWithKeyData(details, PayuConstants.LAZYPAY));
                        }
                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.MC)) {
                            payuResponse.setMealCard(prepareListWithKeyData(details, PayuConstants.MC));
                        }
                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.P_BNPL)) {
                            ArrayList<Bnpl> bnplList = prepareBnplListWithKeyData(details, PayuConstants.P_BNPL);
                            if (bnplList != null && !bnplList.isEmpty()) {
                                payuResponse.setBnpl(bnplList);
                            }
                        }
                        if (isJSONObjectAvailableForKey(paymentOptions, PayuConstants.CLW)) {
                            payuResponse.setClosedLoopWallet(prepareListWithKeyData(details, PayuConstants.CLW));
                        }

                    }
                }
                if (resp.has(PayuConstants.STATUS) && resp.getString(PayuConstants.STATUS).contentEquals(PayuConstants.STRING_ZERO)) {
                    postData = new PostData();
                    postData.setCode(PayuErrors.INVALID_HASH);
                    postData.setStatus(PayuConstants.ERROR);
                    postData.setResult(resp.getString(PayuConstants.MSG));
                } else {
                    postData.setCode(PayuErrors.NO_ERROR);
                    // Result status should be success
                    postData.setResult(PayuErrors.DETAILS_FETCHED_SUCCESSFULLY);
                    postData.setStatus(PayuConstants.SUCCESS);
                }
            }
        } catch (ProtocolException e) {
            postData.setCode(PayuErrors.PROTOCOL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (UnsupportedEncodingException e) {
            postData.setCode(PayuErrors.UN_SUPPORTED_ENCODING_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (JSONException e) {
            postData.setCode(PayuErrors.JSON_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (IOException e) {
            postData.setCode(PayuErrors.IO_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } finally {
            if (responseInputStream != null)
                PayuUtils.safeClose(responseInputStream);
        }

        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    private Upi getUpi(JSONArray offersArray, JSONObject upiObject) throws JSONException {
        Upi upi = new Upi();
        upi.setTitle(upiObject.optString(PayuConstants.TITLE));
        upi.setAdditionalCharge(upiObject.optString(PayuConstants.ADDITIONAL_CHARGE));
        upi.setOfferDetailsList(getOffersList(offersArray, upiObject.optJSONArray(PayuConstants.OFFERS)));
        //TODO: change OPT to get
        upi.setImageUpdatedOn(dateParser(upiObject.optString(PayuConstants.PAYMENT_OPTION_ASSET_UPDATED_ON)));
        //TODO: change OPT to get
        upi.setImageURL(upiObject.optString(PayuConstants.PAYMENT_OPTION_ASSET_URL));
        upi.setCategory(upiObject.getString(PayuConstants.PAYMENT_OPTION_CATEGORY));
        return upi;
    }

    private ArrayList<Emi> getEmiList(JSONObject details, String emiType) throws JSONException {
        JSONArray response = details.getJSONObject(PayuConstants.PAYMENT_OPTIONS).getJSONArray(PayuConstants.EMI_IN_RESPONSE);
        ArrayList<Emi> emiList = new ArrayList<>();
        for (int i = 0; i < response.length(); i++) {
            JSONObject emiObject = response.getJSONObject(i);
            if (emiObject != null && emiType.equalsIgnoreCase(emiObject.getString(PayuConstants.IBIBOCODE)) &&
                    emiObject.optJSONArray(PayuConstants.PAYU_ALL) != null) {
                JSONArray banksList = emiObject.getJSONArray(PayuConstants.PAYU_ALL);

                for (int j = 0; j < banksList.length(); j++) {
                    Emi emi = new Emi();
                    JSONObject currentObject = banksList.getJSONObject(j);
                    JSONObject tenureOptionsList = currentObject.getJSONObject(PayuConstants.TENURE_OPTIONS);
                    JSONObject eligibility = currentObject.optJSONObject(PayuConstants.ELIGIBILITY);
                    Iterator<String> tenureKeysIterator = tenureOptionsList.keys();

                    emi.setBankTitle(currentObject.optString(PayuConstants.TITLE));
                    emi.setShortTitle(currentObject.optString(PayuConstants.SHORT_TITLE));
                    emi.setMinAmount(currentObject.optString(PayuConstants.EMI_MINIMUM_AMOUNT));
                    emi.setMaxAmount(currentObject.optString(PayuConstants.EMI_MAXIMUM_AMOUNT));
                    emi.setBankName(currentObject.getString(PayuConstants.IBIBOCODE));

                    //TODO: change OPT to get
                    emi.setImageUpdatedOn(dateParser(currentObject.optString(PayuConstants.PAYMENT_OPTION_ASSET_UPDATED_ON)));
                    //TODO: change OPT to get
                    emi.setImageURL(currentObject.optString(PayuConstants.PAYMENT_OPTION_ASSET_URL));
                    emi.setCategory(currentObject.getString(PayuConstants.PAYMENT_OPTION_CATEGORY));
                    emi.setBankCode(currentObject.getString(PayuConstants.IBIBOCODE));


                    if (eligibility != null) {
                        emi.setStatus(eligibility.optBoolean(PayuConstants.ELIGIBILITY_STATUS));
                        emi.setReason(eligibility.optString(PayuConstants.ELIGIBILITY_REASON));
                    }
                    ArrayList<PayUEmiTenures> payUEmiTenuresList = new ArrayList<>();

                    while (tenureKeysIterator.hasNext()) {
                        String bankCode = tenureKeysIterator.next();
                        JSONObject tenureObject = tenureOptionsList.getJSONObject(bankCode);
                        PayUEmiTenures payUEmiTenures = new PayUEmiTenures();
                        payUEmiTenures.setBankCode(bankCode);
                        payUEmiTenures.setAdditionalCharge(tenureObject.optString(PayuConstants.ADDITIONAL_CHARGE));
                        payUEmiTenures.setBankDown(getBankDownStatus(details.optJSONObject(PayuConstants.DOWN_INFO), PayuConstants.EMI_IN_RESPONSE, bankCode));
                        payUEmiTenures.setOfferDetailsList(getOffersList(details.optJSONArray(PayuConstants.OFFERS), tenureObject.optJSONArray(PayuConstants.OFFERS)));
                        payUEmiTenures.setMinAmount(tenureObject.optString(PayuConstants.EMI_MINIMUM_AMOUNT));
                        payUEmiTenures.setMaxAmount(tenureObject.optString(PayuConstants.EMI_MAXIMUM_AMOUNT));
                        payUEmiTenures.setTenure(tenureObject.optString(PayuConstants.EMI_TENURE));
                        payUEmiTenures.setInterestRate(tenureObject.optString(PayuConstants.EMI_INTEREST_RATE));
                        payUEmiTenures.setMonthlyEmi(tenureObject.optString(PayuConstants.EMI_MONTHLY));
                        payUEmiTenures.setInterestCharged(tenureObject.optString(PayuConstants.EMI_INTEREST_CHARGED));
                        payUEmiTenures.setPaybackAmount(tenureObject.optString(PayuConstants.EMI_PAYBACK_AMOUNT));
                        payUEmiTenures.setBankCharge(tenureObject.optString(PayuConstants.BANK_CHARGE));
                        //TODO: change OPT to get
                        payUEmiTenures.setImageUpdatedOn(dateParser(currentObject.optString(PayuConstants.PAYMENT_OPTION_ASSET_UPDATED_ON)));
                        //TODO: change OPT to get
                        payUEmiTenures.setImageURL(currentObject.optString(PayuConstants.PAYMENT_OPTION_ASSET_URL));
                        payUEmiTenures.setCategory(currentObject.getString(PayuConstants.PAYMENT_OPTION_CATEGORY));


                        if (eligibility != null) {
                            payUEmiTenures.setStatus(eligibility.optBoolean(PayuConstants.ELIGIBILITY_STATUS));
                            payUEmiTenures.setReason(eligibility.optString(PayuConstants.ELIGIBILITY_REASON));
                        }
                        payUEmiTenuresList.add(payUEmiTenures);
                    }
                    emi.setPayUEmiTenuresList(payUEmiTenuresList);
                    emiList.add(emi);
                }
            }
        }
        return emiList;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mCheckoutDetailsListener.onCheckoutDetailsResponse(payuResponse);
    }

    private PaymentDetails getPhonePeIntentFromList(ArrayList<PaymentDetails> paymentDetailsList) {
        if (paymentDetailsList == null || paymentDetailsList.size() == 0 || com.payu.paymentparamhelper.PayuConstants.PHONEPE_INTENT == null || com.payu.paymentparamhelper.PayuConstants.PHONEPE_INTENT.isEmpty())
            return null;

        for (PaymentDetails paymentDetails : paymentDetailsList) {
            if (paymentDetails.getBankCode().equalsIgnoreCase(com.payu.paymentparamhelper.PayuConstants.PHONEPE_INTENT))
                return paymentDetails;
        }
        return null;
    }

    private ArrayList<PaymentDetails> prepareListWithKeyData(JSONObject details, String key) throws JSONException {
        JSONArray response = details.getJSONObject(PayuConstants.PAYMENT_OPTIONS).getJSONArray(key);
        ArrayList<PaymentDetails> paymentDetailsList = new ArrayList<>();


        for (int i = 0; i < response.length(); i++) {
            PaymentDetails paymentDetails = new PaymentDetails();
            JSONObject responseObject = response.getJSONObject(i);
            paymentDetails.setImageUpdatedOn(dateParser(responseObject.optString(PayuConstants.PAYMENT_OPTION_ASSET_UPDATED_ON)));
            paymentDetails.setImageURL(responseObject.optString(PayuConstants.PAYMENT_OPTION_ASSET_URL));
            paymentDetails.setCategory(responseObject.getString(PayuConstants.PAYMENT_OPTION_CATEGORY));

            paymentDetails.setBankCode(responseObject.getString(PayuConstants.IBIBOCODE));
            paymentDetails.setBankName(responseObject.optString(PayuConstants.TITLE));
            paymentDetails.setAdditionalCharge(responseObject.optString(PayuConstants.ADDITIONAL_CHARGE));
            paymentDetails.setBankDown(getBankDownStatus(details.optJSONObject(PayuConstants.DOWN_INFO), key, responseObject.getString(PayuConstants.IBIBOCODE)));
            paymentDetails.setOfferDetailsList(getOffersList(details.optJSONArray(PayuConstants.OFFERS), responseObject.optJSONArray(PayuConstants.OFFERS)));
            paymentDetails.setIfscCode(responseObject.optString(PayuConstants.P_IFSC_CODE));
            JSONArray verificationModeJsonArray = responseObject.optJSONArray(PayuConstants.VERTIFICATION_MODE);
            if (null != verificationModeJsonArray && verificationModeJsonArray.length() > 0) {
                paymentDetails.setVerificationModeList(getArrayListFromJsonArray(verificationModeJsonArray));
            }
            paymentDetails.setIsSecureWebview(responseObject.optBoolean(PayuConstants.SECURE_WEBVIEW));
            paymentDetailsList.add(paymentDetails);
        }
        return paymentDetailsList;
    }

    private ArrayList<String> getArrayListFromJsonArray(JSONArray jsonArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); i++) {
                try {
                    arrayList.add(jsonArray.get(i).toString());
                } catch (JSONException e) {
                    Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
                }
            }
        }
        return arrayList;
    }

    private ArrayList<PayuOffer> getOffersList(JSONArray fullArray, JSONArray offerArray) {
        if (fullArray == null || fullArray.length() == 0 || offerArray == null || offerArray.length() == 0)
            return null;

        ArrayList<PayuOffer> offersList = new ArrayList<>();
        for (int i = 0; i < offerArray.length(); i++) {
            JSONObject jsonObject = offerArray.optJSONObject(i);
            if (jsonObject != null) {
                String id = jsonObject.optString(PayuConstants.ID);
                if (id == null || id.isEmpty() || id.equalsIgnoreCase("null"))
                    continue;

                for (int j = 0; j < fullArray.length(); j++) {
                    JSONObject fullJsonObject = fullArray.optJSONObject(j);
                    if (fullJsonObject != null) {
                        String idFullArray = fullJsonObject.optString(PayuConstants.ID);
                        if (idFullArray != null && idFullArray.equalsIgnoreCase(id)) {
                            PayuOffer payuOffer = new PayuOffer();
                            payuOffer.setId(fullJsonObject.optString(PayuConstants.ID));
                            payuOffer.setTitle(fullJsonObject.optString(PayuConstants.TITLE));
                            payuOffer.setDescription(fullJsonObject.optString(PayuConstants.DESCRIPTION));
                            payuOffer.setMinAmount(fullJsonObject.optString(PayuConstants.PAYU_MIN_AMOUNT));
                            payuOffer.setDiscount(fullJsonObject.optString(PayuConstants.DISCOUNT));
                            payuOffer.setDiscountUnit(fullJsonObject.optString(PayuConstants.DISCOUNT_UNIT));
                            payuOffer.setOfferType(fullJsonObject.optString(PayuConstants.OFFER_TYPE));
                            payuOffer.setValidOnDays(fullJsonObject.optString(PayuConstants.VALID_ON_DAYS));
                            payuOffer.setOfferKey("@" + fullJsonObject.optString(PayuConstants.ID));
                            offersList.add(payuOffer);
                        }
                    }
                }
            }
        }
        return offersList;
    }

    private boolean getBankDownStatus(JSONObject downInfoObject, String key, String bankCode) {
        if (downInfoObject == null || downInfoObject.length() == 0 || key == null || key.equalsIgnoreCase(PayuConstants.PAYU_CC) || key.equalsIgnoreCase(PayuConstants.PAYU_DC))
            return false;

        JSONArray banksArray = downInfoObject.optJSONArray(key);
        if (banksArray != null && banksArray.length() != 0) {
            for (int i = 0; i < banksArray.length(); i++) {
                if (banksArray.optString(i) != null && banksArray.optString(i).equalsIgnoreCase(bankCode))
                    return true;
            }
        }
        return false;
    }

    private String getTaxFromConfigObject(JSONObject configObject, String key) throws JSONException {
        if (configObject == null || configObject.length() == 0 || configObject.optJSONObject(PayuConstants.TAX_SPECIFICATION) == null)
            return null;

        JSONObject taxSpecification = configObject.getJSONObject(PayuConstants.TAX_SPECIFICATION);
        //check if tax is applied for specific mode
        if (taxSpecification.has(key) && !taxSpecification.getString(key).equalsIgnoreCase("0"))
            return taxSpecification.getString(key);
        else if (taxSpecification.has(PayuConstants.DEFAULT))
            return taxSpecification.getString(PayuConstants.DEFAULT);
        else return null;
    }


    private boolean isJSONObjectAvailableForKey(JSONObject paymentOptions, String key) {
        return paymentOptions.has(key) && paymentOptions.optJSONArray(key) != null;
    }

    private long dateParser(String value) {
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyyy-mm-dd hh:mm:ss");
            return dt.parse(value).getTime();
        } catch (Exception e) {

        }
        return 0;
    }

    private ArrayList<Bnpl> prepareBnplListWithKeyData(JSONObject details, String key) throws JSONException {
        JSONArray allObject = details.getJSONObject(PayuConstants.PAYMENT_OPTIONS).getJSONArray(key);
        ArrayList<Bnpl> paymentDetailsList = new ArrayList<>();
        for (int i = 0; i < allObject.length(); i++) {
            JSONObject bnplObject = allObject.getJSONObject(i);
            Bnpl paymentDetails = new Bnpl();
            paymentDetails.setBankCode(bnplObject.optString(PayuConstants.IBIBOCODE));
            paymentDetails.setBankName(bnplObject.optString(PayuConstants.TITLE));
            paymentDetails.setAdditionalCharge(bnplObject.optString(PayuConstants.ADDITIONAL_CHARGE));
            paymentDetails.setMinAmount(bnplObject.optString(PayuConstants.EMI_MINIMUM_AMOUNT));
            paymentDetails.setMaxAmount(bnplObject.optString(PayuConstants.EMI_MAXIMUM_AMOUNT));
            JSONObject eligibility = bnplObject.optJSONObject(PayuConstants.ELIGIBILITY);
            paymentDetails.setImageUpdatedOn(dateParser(bnplObject.optString(PayuConstants.PAYMENT_OPTION_ASSET_UPDATED_ON)));
            paymentDetails.setImageURL(bnplObject.optString(PayuConstants.PAYMENT_OPTION_ASSET_URL));
            paymentDetails.setCategory(bnplObject.getString(PayuConstants.PAYMENT_OPTION_CATEGORY));
            if (eligibility != null) {
                paymentDetails.setStatus(eligibility.optBoolean(PayuConstants.ELIGIBILITY_STATUS));
                paymentDetails.setReason(eligibility.optString(PayuConstants.ELIGIBILITY_REASON));
            }
            paymentDetailsList.add(paymentDetails);
        }
        return paymentDetailsList;
    }

    private void updateSiApps(JSONObject siDetails, PayuResponse payuResponse) throws JSONException {
        JSONArray siSupportedApps = siDetails.optJSONArray(PayuConstants.UPI_SI_APPS);
        if (siSupportedApps != null) {
            ArrayList<String> appsList = new ArrayList<>();

            for (int i = 0; i < siSupportedApps.length(); i++) {
                appsList.add(String.valueOf(siSupportedApps.get(i)));
            }
            payuResponse.setUpiSISupportedApps(appsList);
        }

        JSONArray siSupportedHandles = siDetails.optJSONArray(PayuConstants.UPI_SI_HANDLES);
        if (siSupportedHandles != null) {
            ArrayList<String> handleList = new ArrayList<>();
            for (int i = 0; i < siSupportedHandles.length(); i++) {
                handleList.add(String.valueOf(siSupportedHandles.get(i)));
            }
            payuResponse.setUpiSISupportedHandles(handleList);
        }
    }

}
