package com.payu.india.Tasks;

import android.util.Log;

import com.payu.india.Interfaces.FetchOfferDetailsListener;
import com.payu.india.Model.BankOfferInfoCards;
import com.payu.india.Model.CardsOfferInfo;
import com.payu.india.Model.DiscountDetailsofOffers;
import com.payu.india.Model.EMIOptionInOffers;
import com.payu.india.Model.EmiOfferInfo;
import com.payu.india.Model.FetchOfferInfo;
import com.payu.india.Model.FetchofferDetails;
import com.payu.india.Model.NetworkOfferInfoCards;
import com.payu.india.Model.PayUUserDetails;
import com.payu.india.Model.PaymentOptionOfferinfo;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.SkuOfferInfo;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.base.PayUAsyncTask;
import com.payu.paymentparamhelper.Sku;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;

import javax.net.ssl.HttpsURLConnection;

public class FetchOfferDetailsTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private FetchOfferDetailsListener mfetchOfferDetailsListener;

    public FetchOfferDetailsTask(FetchOfferDetailsListener fetchOfferDetailsListener) {
        mfetchOfferDetailsListener = fetchOfferDetailsListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        InputStream responseInputStream = null;

        try {
            URL url = null;
            // get the payuConfig first
            //TODO put check if payuConfig has data
            PayuConfig payuConfig = params[0];
            // set the environment

            //TODO make it function call
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_APIV2_URL);
                    break;
                default:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
            }

            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).
                    setURL(url + PayuConstants.FETCHOFFER_API_ENDPOINT).setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeaderWithSource(PayuConstants.PAYU_GET_OFFER_DETAILS)).
                    setRequestType(PayuConstants.REQUEST_APPLICATION_JSON).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);

            //TODO decide on architecture and move common code to generic class
            if (null != conn) {
                responseInputStream = conn.getInputStream();
                StringBuilder responseStringBuffer = new StringBuilder();
                byte[] byteContainer = new byte[1024];
                for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }

                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);

                JSONObject result = response.optJSONObject(PayuConstants.P_RESULT);

                FetchofferDetails fetchofferDetails = new FetchofferDetails();
                if (result != null) {
                    fetchofferDetails.setUserPersonalizedOffersAvailable(result.optBoolean(PayuConstants.IS_USER_PERSONALIZED_OFFER_AVAILABLE));
                    fetchofferDetails.setCouponsAvailable(result.optBoolean(PayuConstants.PAYU_PARAM_COUPONS_AVAILABLE));

                    JSONArray offers = result.optJSONArray(PayuConstants.OFFERS);
                    if (offers != null && offers.length() > 0) {
                        ArrayList<FetchOfferInfo> offerInfoArrayList = new ArrayList<>();
                        for (int i = 0; i < offers.length(); i++) {
                            JSONObject offersJson = offers.getJSONObject(i);
                            FetchOfferInfo fetchOfferInfo = new FetchOfferInfo();
                            preparePaymentOffersList(fetchOfferInfo, offersJson);
                            offerInfoArrayList.add(fetchOfferInfo);
                        }
                        fetchofferDetails.setPayuOfferList(offerInfoArrayList);
                    }
                    JSONObject skusDetail = result.optJSONObject(PayuConstants.PAYU_SKUS_DETAILS);
                    if (skusDetail != null) {
                        JSONArray skus = skusDetail.optJSONArray(PayuConstants.P_SKUS);
                        ArrayList<SkuOfferInfo> skuOfferInfoArrayList = new ArrayList<>();
                        for (int i = 0; skus != null && i < skus.length(); i++) {
                            SkuOfferInfo skuOfferInfo = new SkuOfferInfo();
                            JSONObject skuJson = skus.optJSONObject(i);
                            JSONArray skuOffers = skuJson.optJSONArray(PayuConstants.OFFERS);
                            if (skuOffers != null && skuOffers.length() > 0) {
                                String skuId = skuJson.optString(PayuConstants.P_SKU_ID);
                                String skuAmount = skuJson.optString(PayuConstants.P_SKU_AMOUNT);
                                int skuQuantity = skuJson.optInt(PayuConstants.P_QUANTITY);
                                ArrayList<FetchOfferInfo> offerInfoArrayList = new ArrayList<>();
                                for (int j = 0; j < skuOffers.length(); j++) {
                                    FetchOfferInfo fetchOfferInfo = new FetchOfferInfo();
                                    JSONObject offersJson = skuOffers.getJSONObject(j);
                                    preparePaymentOffersList(fetchOfferInfo, offersJson);
                                    offerInfoArrayList.add(fetchOfferInfo);
                                }
                                Sku sku = new Sku();
                                sku.setSkuId(skuId);
                                sku.setSkuAmount(skuAmount);
                                sku.setQuantity(skuQuantity);
                                skuOfferInfo.setOfferInfoArrayList(offerInfoArrayList);
                                skuOfferInfo.setSku(sku);
                                skuOfferInfoArrayList.add(skuOfferInfo);
                            }
                        }
                        fetchofferDetails.setSkuOfferInfoList(skuOfferInfoArrayList);
                    }
                    payuResponse.setFetchofferDetails(fetchofferDetails);
                }
                PayuUtils.safeClose(responseInputStream);
            }
        } catch (ProtocolException e) {
        } catch (IOException e) {
        } catch (JSONException e) {
        } finally {
            if (responseInputStream != null)
                PayuUtils.safeClose(responseInputStream);
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }


    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mfetchOfferDetailsListener.onFetchOfferDetailsResponse(payuResponse);
    }

    private ArrayList<PaymentOptionOfferinfo> prepareOfferDetailsInfo(String paymentOption, JSONObject offersarray) {
        ArrayList<PaymentOptionOfferinfo> paymentOptionOfferinfoArrayList = new ArrayList<>();
        JSONArray paymentOptionJson = offersarray.optJSONArray(paymentOption);
        for (int j = 0; paymentOptionJson != null && j < paymentOptionJson.length(); j++) {
            JSONObject paymentDetailsForOffer = null;
            try {
                paymentDetailsForOffer = paymentOptionJson.getJSONObject(j);
            } catch (JSONException e) {
                Log.d(getClass().getSimpleName(), "Exception " + e.getMessage());
            }
            PaymentOptionOfferinfo paymentOptionOfferinfo = new PaymentOptionOfferinfo();
            paymentOptionOfferinfo.setPaymentOptionName(paymentOption);
            paymentOptionOfferinfo.setTitle(paymentDetailsForOffer.optString(PayuConstants.P_TITLE));
            paymentOptionOfferinfo.setPaymentCode(paymentDetailsForOffer.optString(PayuConstants.P_PAYMENTCODE));
            paymentOptionOfferinfoArrayList.add(paymentOptionOfferinfo);
        }
        return paymentOptionOfferinfoArrayList;
    }

    private void prepareOfferDetailsInfoForCards(String paymentOption, JSONObject offersarray, NetworkOfferInfoCards networkOfferInfoCards,
                                                 BankOfferInfoCards bankOfferInfoCards, FetchOfferInfo fetchOfferInfo) {
        ArrayList<PaymentOptionOfferinfo> networkListForCards = new ArrayList<>();
        ArrayList<PaymentOptionOfferinfo> bankListForCards = new ArrayList<>();
        JSONArray paymentOptionJson = offersarray.optJSONArray(paymentOption);
        for (int j = 0; paymentOptionJson != null && j < paymentOptionJson.length(); j++) {
            try {
                JSONObject paymentDetailsForOffer = paymentOptionJson.getJSONObject(j);
                JSONArray networkDetailsOffer = paymentDetailsForOffer.optJSONArray(PayuConstants.NETWORK);
                JSONArray banksDetailsOffer = paymentDetailsForOffer.optJSONArray(PayuConstants.P_BANKS);

                for (int k = 0; networkDetailsOffer != null && k < networkDetailsOffer.length(); k++) {
                    PaymentOptionOfferinfo paymentOptionOfferinfo = prepareCardOfferDetails(networkDetailsOffer.getJSONObject(k), paymentOption);
                    networkListForCards.add(paymentOptionOfferinfo);
                }

                for (int k = 0; banksDetailsOffer != null && k < banksDetailsOffer.length(); k++) {
                    PaymentOptionOfferinfo paymentOptionOfferinfo = prepareCardOfferDetails(banksDetailsOffer.getJSONObject(k), paymentOption);
                    bankListForCards.add(paymentOptionOfferinfo);
                }
            } catch (JSONException e) {
                Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
            }
        }
        if (Objects.equals(paymentOption, PayuConstants.P_CREDITCARD)) {
            networkOfferInfoCards.setNetworkListForCCCards(networkListForCards);
            bankOfferInfoCards.setBanksListForCCCards(bankListForCards);
        } else {
            networkOfferInfoCards.setNetworkListForDCCards(networkListForCards);
            bankOfferInfoCards.setBanksListForDCCards(bankListForCards);
        }
        CardsOfferInfo cardsOfferInfo = new CardsOfferInfo();
        cardsOfferInfo.setBankOfferInfoCards(bankOfferInfoCards);
        cardsOfferInfo.setNetworkOfferInfoCards(networkOfferInfoCards);
        fetchOfferInfo.setCardsOfferInfo(cardsOfferInfo);

    }

    private PaymentOptionOfferinfo prepareCardOfferDetails(JSONObject jsonObject, String paymentOption) {
        PaymentOptionOfferinfo paymentOptionOfferinfo = new PaymentOptionOfferinfo();
        paymentOptionOfferinfo.setPaymentOptionName(paymentOption);
        paymentOptionOfferinfo.setTitle(jsonObject.optString(PayuConstants.P_TITLE));
        paymentOptionOfferinfo.setPaymentCode(jsonObject.optString(PayuConstants.P_CODE));
        return paymentOptionOfferinfo;
    }

    private ArrayList<EMIOptionInOffers> prepareOffersInfoForEmi(String paymentOption, JSONObject emiObject) {
        JSONObject emiTypeJsonObject = emiObject.optJSONObject(paymentOption);
        ArrayList<EMIOptionInOffers> eMiOptionInOffersArrayList = new ArrayList<>();
        if (emiTypeJsonObject != null) {
            JSONArray emiBanks = emiTypeJsonObject.optJSONArray(PayuConstants.P_BANKS);
            for (int i = 0; emiBanks != null && i < emiBanks.length(); i++) {
                JSONObject emiBanksObject = emiBanks.optJSONObject(i);
                EMIOptionInOffers eMiOptionInOffers = new EMIOptionInOffers();
                eMiOptionInOffers.setEmiType(paymentOption);
                eMiOptionInOffers.setBankCode(emiBanksObject.optString(PayuConstants.PG_BANK_CODE));
                ArrayList<PaymentOptionOfferinfo> paymentOptionOfferInfoList = new ArrayList<>();
                JSONArray emiTenures = emiBanksObject.optJSONArray(PayuConstants.TENURE_OPTION);
                for (int j = 0; emiTenures != null && j < emiTenures.length(); j++) {
                    PaymentOptionOfferinfo paymentOptionOfferinfo = new PaymentOptionOfferinfo();
                    JSONObject emiTenuresObject = emiTenures.optJSONObject(j);
                    paymentOptionOfferinfo.setPaymentCode(emiTenuresObject.optString(PayuConstants.P_PAYMENTCODE));
                    paymentOptionOfferinfo.setTitle(emiTenuresObject.optString(PayuConstants.TITLE));
                    paymentOptionOfferInfoList.add(paymentOptionOfferinfo);
                }
                eMiOptionInOffers.setPaymentOptionOfferinfoArrayList(paymentOptionOfferInfoList);
                eMiOptionInOffersArrayList.add(eMiOptionInOffers);
            }
        }
        return eMiOptionInOffersArrayList;
    }

    private void preparePaymentOffersList(FetchOfferInfo fetchOfferInfo, JSONObject offersJson) {
        try {
            fetchOfferInfo.setType(offersJson.optString(PayuConstants.SPLIT_PAYMENT_TYPE));
            fetchOfferInfo.setOfferKey(offersJson.optString(PayuConstants.F_OFFER_KEY));
            fetchOfferInfo.setTitle(offersJson.optString(PayuConstants.TITLE));
            fetchOfferInfo.setDescription(offersJson.optString(PayuConstants.DESCRIPTION));
            fetchOfferInfo.setTnc(offersJson.optString(PayuConstants.P_TNC));
            fetchOfferInfo.setTncLink(offersJson.optString(PayuConstants.P_TNCLINK));
            fetchOfferInfo.setMinTxnAmount(Double.parseDouble(Objects.requireNonNull(offersJson.opt(PayuConstants.P_MINTXNAMT)).toString()));
            fetchOfferInfo.setMaxTxnAmount(Double.parseDouble(Objects.requireNonNull(offersJson.opt(PayuConstants.P_MAXTXNAMT)).toString()));
            fetchOfferInfo.setOfferType(offersJson.optString(PayuConstants.P_OFFERTYPE));
            fetchOfferInfo.setValidFrom(offersJson.optString(PayuConstants.P_VALIDFROM));
            fetchOfferInfo.setValidTo(offersJson.optString(PayuConstants.P_VALIDTO));
            fetchOfferInfo.setSkuOffer(offersJson.optBoolean(PayuConstants.P_IS_SKU_OFFER));
            fetchOfferInfo.setAllPayModeOffer(offersJson.optBoolean(PayuConstants.P_IS_ALL_P_MODE));
            fetchOfferInfo.setOfferCategory(PayuUtils.getStringValue(offersJson, PayuConstants.P_OFFER_CATEGORY));
            fetchOfferInfo.setAmount(PayuUtils.getDoubleValue(offersJson, PayuConstants.AMOUNT));
            fetchOfferInfo.setDiscount(PayuUtils.getDoubleValue(offersJson, PayuConstants.DISCOUNT));
            fetchOfferInfo.setDiscountedAmount(PayuUtils.getDoubleValue(offersJson, PayuConstants.P_DISCOUNTEDAMT));
            fetchOfferInfo.setToDisplay(offersJson.optBoolean(PayuConstants.PAYU_PARAM_TO_DISPLAY));
            fetchOfferInfo.setUserVerificationRequired(offersJson.optBoolean(PayuConstants.PAYU_PARAM_IS_USER_VERIFICATION_REQUIRED));
            DiscountDetailsofOffers discountDetailsofOffers = new DiscountDetailsofOffers();
            if (offersJson.optJSONObject(PayuConstants.P_DISCOUNT_DETAILS) != null) {
                JSONObject discountJsonObject = offersJson.getJSONObject(PayuConstants.P_DISCOUNT_DETAILS);
                discountDetailsofOffers.setMaxDiscount(Double.parseDouble(!discountJsonObject.get(PayuConstants.P_MAXDICOUNT).equals(null) ? discountJsonObject.get(PayuConstants.P_MAXDICOUNT).toString() : "0"));
                discountDetailsofOffers.setDiscountPercentage(discountJsonObject.optString(PayuConstants.P_DISCOUNT_PNT));
                discountDetailsofOffers.setDiscount(Double.parseDouble(!discountJsonObject.get(PayuConstants.P_DISCOUNT).equals(null) ? discountJsonObject.get(PayuConstants.P_DISCOUNT).toString() : "0"));
                discountDetailsofOffers.setDiscountType(discountJsonObject.optString(PayuConstants.P_DISCOUNTTYPE));
                discountDetailsofOffers.setDiscountedAmount(Double.parseDouble(!discountJsonObject.get(PayuConstants.P_DISCOUNTEDAMT).equals(null) ? discountJsonObject.get(PayuConstants.P_DISCOUNTEDAMT).toString() : "0"));
                fetchOfferInfo.setDiscountDetails(discountDetailsofOffers);
            }
            fetchOfferInfo.setIsNoCostEmi(offersJson.optBoolean(PayuConstants.P_IS_NO_COST_EMI));
            BankOfferInfoCards bankOfferInfoCards = new BankOfferInfoCards();
            NetworkOfferInfoCards networkOfferInfoCards = new NetworkOfferInfoCards();
            if (offersJson.optJSONArray(PayuConstants.P_CREDITCARD) != null) {
                prepareOfferDetailsInfoForCards(PayuConstants.P_CREDITCARD, offersJson, networkOfferInfoCards, bankOfferInfoCards, fetchOfferInfo);
            }
            if (offersJson.optJSONArray(PayuConstants.P_DEBITCARD) != null) {
                prepareOfferDetailsInfoForCards(PayuConstants.P_DEBITCARD, offersJson, networkOfferInfoCards, bankOfferInfoCards, fetchOfferInfo);
            }
            if (offersJson.optJSONArray(PayuConstants.NETBANKING_OFFER) != null) {
                fetchOfferInfo.setNbOfferList(prepareOfferDetailsInfo(PayuConstants.NETBANKING_OFFER, offersJson));
            }
            if (offersJson.optJSONArray(PayuConstants.WALLET) != null) {
                fetchOfferInfo.setWalletOfferList(prepareOfferDetailsInfo(PayuConstants.WALLET, offersJson));
            }
            if (offersJson.optJSONArray(PayuConstants.UPI) != null) {
                fetchOfferInfo.setUpiOfferList(prepareOfferDetailsInfo(PayuConstants.UPI, offersJson));
            }
            if (offersJson.optJSONArray(PayuConstants.BNPL.toLowerCase()) != null) {
                fetchOfferInfo.setBnplOfferList(prepareOfferDetailsInfo(PayuConstants.BNPL.toLowerCase(), offersJson));
            }
            if (offersJson.optJSONArray(PayuConstants.CLW.toLowerCase()) != null) {
                fetchOfferInfo.setClwOfferInfoList(prepareOfferDetailsInfo(PayuConstants.CLW.toLowerCase(), offersJson));
            }
            if (offersJson.optJSONObject(PayuConstants.EMI.toLowerCase()) != null) {
                JSONObject emiObject = offersJson.optJSONObject(PayuConstants.EMI.toLowerCase());
                EmiOfferInfo emiOfferInfo = new EmiOfferInfo();
                emiOfferInfo.setEmiDCOffersArrayList(prepareOffersInfoForEmi(PayuConstants.P_DEBITCARD, emiObject));
                emiOfferInfo.setEmiCCOffersArrayList(prepareOffersInfoForEmi(PayuConstants.P_CREDITCARD, emiObject));
                //TODO will enable when tested
//                emiOfferInfo.setEmiCardLessOffersArrayList(prepareOffersInfoForEmi(PayuConstants.P_CARD_LESS, emiObject));
                fetchOfferInfo.setEmiOfferInfo(emiOfferInfo);
            }

            PayUUserDetails userDetails = new PayUUserDetails();
            if (offersJson.optJSONObject(PayuConstants.P_USER_DETAILS) != null) {
                JSONObject userDetailJsonObject = offersJson.getJSONObject(PayuConstants.P_USER_DETAILS);
                userDetails.setFirstName(userDetailJsonObject.optString(PayuConstants.PAYU_PARAM_FIRST_NAME));
                userDetails.setPhoneNo(userDetailJsonObject.optString(PayuConstants.P_PHONE_NO));
                userDetails.setEmail(userDetailJsonObject.optString(PayuConstants.EMAIL));
                fetchOfferInfo.setUserDetails(userDetails);
            }

        } catch (JSONException e) {
            Log.d("PayU", Objects.requireNonNull(e.getMessage()));
        }
    }

}
