package com.payu.india.Tasks;

import android.util.Log;

import com.payu.india.Interfaces.FetchAdsInformationApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.adsinformation.AdsInformationResponse;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;


/**
 * Async task which takes care of Fetch Ads for activity
 * Takes PayuConfig as input and sends PayuResponse to the calling activity
 */
public class FetchAdsInformationTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private FetchAdsInformationApiListener mFetchAdsInformationApiListener;

    public FetchAdsInformationTask(FetchAdsInformationApiListener fetchAdsInformationApiListener) {
        mFetchAdsInformationApiListener = fetchAdsInformationApiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        InputStream responseInputStream = null;
        try {
            URL url;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_APIV2_URL);
                    break;
                default:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
            }

            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).
                    setURL(url + PayuConstants.FETCH_ADS_API_ENDPOINT).setPostData(payuConfig.getData()).
                    setRequestType(PayuConstants.REQUEST_APPLICATION_CHAR_JSON).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {

                responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }

                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has(PayuConstants.STATUS) && response.has(PayuConstants.CP_ASSETS_DETAILS)) {
                    JSONArray assetsArray = response.optJSONArray(PayuConstants.CP_ASSETS_DETAILS);
                    if (assetsArray != null && assetsArray.length() != 0) {
                        JSONObject assetsObject = assetsArray.getJSONObject(0);
                        AdsInformationResponse adsInformationResponse = new AdsInformationResponse();
                        adsInformationResponse.setImage(assetsObject.optString(PayuConstants.CP_ADS_PATH));
                        adsInformationResponse.setRequestId(assetsObject.optString(PayuConstants.CP_ADS_REQUEST_ID));
                        adsInformationResponse.setAdsSource(assetsObject.optString(PayuConstants.PAYU_SOURCE));
                        payuResponse.setAdsInformation(adsInformationResponse);
                    }
                }
                if (response.has(PayuConstants.STATUS) && response.getBoolean(PayuConstants.STATUS)) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                } else {
                    postData.setResult(response.getString(PayuConstants.PAYU_MESSAGE));
                    postData.setStatus(PayuConstants.ERROR);
                }
            }
            payuResponse.setResponseStatus(postData);
        } catch (IOException | JSONException e) {
            Log.d(getClass().getSimpleName(), "Exception " + e.getMessage());
        } finally {
            if (responseInputStream != null)
                PayuUtils.safeClose(responseInputStream);
        }
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mFetchAdsInformationApiListener.onGetAdsInformationResponse(payuResponse);
    }
}
