package com.payu.india.Payu;

import com.payu.india.Model.Authorization;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class V2ApiHelper {
    private String date;
    private String authHeder;
    private Authorization authorization = new Authorization();
    private static V2ApiHelper instance = null;

    private V2ApiHelper() {
        // Exists only to defeat instantiation.
    }

    public static V2ApiHelper getInstance() {
        if (instance == null) {
            instance = new V2ApiHelper();
        }
        return instance;
    }

    public String generateSigningString(String jsonString) {
        Date myDate = new Date();

        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(myDate);
        calendar.add(Calendar.MINUTE, -330);
        Date time = calendar.getTime();
        SimpleDateFormat outputFmt = new SimpleDateFormat(PayuConstants.V2_API_TIME_FORMATE, Locale.US);

        date = outputFmt.format(time);
        authorization.setDate(date);

        String signingString = new StringBuilder()
                .append(jsonString).append("|").append(date).append("|").toString();
        return signingString;
    }

    public HashMap<String, String> getAuthHeader(String key) {
        HashMap<String, String> headerMap = new HashMap<>();
        headerMap.put(PayuConstants.DATE, authorization.getDate());
        headerMap.put(PayuConstants.PAYU_CONTENT_TYPE, PayuConstants.REQUEST_APPLICATION_JSON);

        authHeder = new StringBuilder()
                .append(PayuConstants.AUTH_HEADER_PARAM_1)
                .append(authorization.getMerchantkey())
                .append(PayuConstants.AUTH_HEADER_PARAM_2)
                .append(authorization.getSignature(key))
                .append("\"").toString();
        headerMap.put(PayuConstants.AUTHORIZATION, authHeder);
        return headerMap;
    }

    public HashMap<String, String> getOlwAuthHeader(String key, HashMap<String, String> headerMapExtra) {
        HashMap<String, String> headerMap = getAuthHeader(key);
        if (!headerMapExtra.isEmpty())
            headerMap.putAll(headerMapExtra);
        return headerMap;
    }

    public HashMap<String, String> getAuthHeaderWithSource(String key) {
        HashMap<String, String> headerMap = getAuthHeader(key);
        headerMap.put(PayuConstants.PAYU_SOURCE, PayuConstants.PAYU_SOURCE_ANDROID_SDK);
        return headerMap;
    }


    public void setAuthHeader(HashMap<String, String> signature, String key) {
        authorization.setMerchantkey(key);
        authorization.setDate(date);
        authorization.setSignature(signature);
    }

    public String getApiEndPoint(String commandName) {
        switch (commandName) {
            case PayuConstants.PAYU_SEND_OTP: {
                return PayuConstants.PAYU_SEND_OTP_ENDPOINT;
            }
            case PayuConstants.PAYU_SET_MPIN:
            case PayuConstants.PAYU_FORGET_MPIN:
                return PayuConstants.PAYU_SET_MPIN_ENDPOINT;
            case PayuConstants.PAYU_VERIFY_MPIN:
                return PayuConstants.PAYU_VERIFY_MPIN_ENDPOINT;
            default:
                throw new IllegalArgumentException("Unknown command name: " + commandName);

        }
    }
}
