package com.payu.india.Payu;

import java.util.HashMap;

public class HttpRequest {
    public enum Method {
        GET,
        POST,
        UPDATE,
        DELETE,
        PUT
    }

    public Method getMethod() {
        return method;
    }

    public String getURL() {
        return URL;
    }

    public HashMap<String, String> getHeaders() {
        return headers;
    }

    public String getPostData() {
        return postData;
    }

    public String getRequestType() {
        return requestType;
    }

    public int getTimeout() {
        return timeout;
    }

    private Method method;
    private String URL;
    private HashMap<String, String> headers;
    private String postData;
    private String requestType;
    private int timeout;

    private HttpRequest(Builder builder) {
        this.method = builder.method;
        this.URL = builder.URL;
        this.headers = builder.headers;
        this.postData = builder.postData;
        this.requestType = builder.requestType;
        this.timeout = builder.timeout;
    }

    public static class Builder {
        public Builder setMethod(Method method) {
            this.method = method;
            return this;
        }

        public Builder setURL(String URL) {
            this.URL = URL;
            return this;
        }

        public Builder setHeaders(HashMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setPostData(String postData) {
            this.postData = postData;
            return this;
        }

        public Builder setRequestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }


        private Method method;
        private String URL;
        private HashMap<String, String> headers;
        private String postData;
        private String requestType;
        private int timeout = -1;


        public HttpRequest build() {
            return new HttpRequest(this);
        }
    }
}
