package com.payu.india.Model.fetchConvenienceFee;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.NonNull;

public class Charges implements Parcelable {
    private String chargeUuid;
    private String chargeName;
    private double baseFee;
    private double taxAmount;
    private String ruleId;

    public Charges() {

    }

    protected Charges(Parcel in) {
        chargeUuid = in.readString();
        chargeName = in.readString();
        baseFee = in.readDouble();
        taxAmount = in.readDouble();
        ruleId = in.readString();
    }

    public static final Creator<Charges> CREATOR = new Creator<Charges>() {
        @Override
        public Charges createFromParcel(Parcel in) {
            return new Charges(in);
        }

        @Override
        public Charges[] newArray(int size) {
            return new Charges[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int i) {
        parcel.writeString(chargeUuid);
        parcel.writeString(chargeName);
        parcel.writeDouble(baseFee);
        parcel.writeDouble(taxAmount);
        parcel.writeString(ruleId);
    }

    public String getChargeUuid() {
        return chargeUuid;
    }

    public void setChargeUuid(String chargeUuid) {
        this.chargeUuid = chargeUuid;
    }

    public String getChargeName() {
        return chargeName;
    }

    public void setChargeName(String chargeName) {
        this.chargeName = chargeName;
    }

    public double getBaseFee() {
        return baseFee;
    }

    public void setBaseFee(double baseFee) {
        this.baseFee = baseFee;
    }

    public double getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(double taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

}
