package com.payu.india.Model.adsinformation;


import android.util.Log;

import com.payu.india.Payu.PayuConstants;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdsApiRequest extends V2ApiBase {
    private JSONArray source;
    private String key;

    private AdsApiRequest(Builder builder) {
        this.source = builder.source;
        this.key = builder.key;
    }

    @Override
    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PayuConstants.PAYU_SOURCE, source);
            jsonObject.put(PayuConstants.PAYU_MERCHANT_KEY, key);
        } catch (JSONException e) {
            Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private JSONArray source;
        private String key;

        public Builder setSource(JSONArray source) {
            this.source = source;
            return this;
        }

        public Builder setKey(String userToken) {
            this.key = userToken;
            return this;
        }

        public AdsApiRequest build() {
            return new AdsApiRequest(this);
        }
    }
}
