package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import com.payu.paymentparamhelper.Sku;
import com.payu.paymentparamhelper.SkuDiscountDetails;

import java.util.ArrayList;

public class SkuOfferInfo implements Parcelable {
    private Sku sku;
    private SkuDiscountDetails skuDiscountDetails;
    private ArrayList<FetchOfferInfo> offerInfoArrayList;

    public SkuOfferInfo() {
    }

    protected SkuOfferInfo(Parcel in) {
        sku = in.readParcelable(Sku.class.getClassLoader());
        offerInfoArrayList = in.createTypedArrayList(FetchOfferInfo.CREATOR);
        skuDiscountDetails = in.readParcelable(SkuDiscountDetails.class.getClassLoader());
    }

    public Sku getSku() {
        return sku;
    }

    public void setSku(Sku sku) {
        this.sku = sku;
    }

    public ArrayList<FetchOfferInfo> getOfferInfoArrayList() {
        return offerInfoArrayList;
    }

    public void setOfferInfoArrayList(ArrayList<FetchOfferInfo> offerInfoArrayList) {
        this.offerInfoArrayList = offerInfoArrayList;
    }

    public SkuDiscountDetails getSkuDiscountDetails() {
        return skuDiscountDetails;
    }

    public void setSkuDiscountDetails(SkuDiscountDetails skuDiscountDetails) {
        this.skuDiscountDetails = skuDiscountDetails;
    }

    public static final Creator<SkuOfferInfo> CREATOR = new Creator<SkuOfferInfo>() {
        @Override
        public SkuOfferInfo createFromParcel(Parcel in) {
            return new SkuOfferInfo(in);
        }

        @Override
        public SkuOfferInfo[] newArray(int size) {
            return new SkuOfferInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeParcelable(sku, i);
        parcel.writeTypedList(offerInfoArrayList);
        parcel.writeParcelable(skuDiscountDetails, i);
    }
}
