package com.payu.india.Model.QuickPay;

import android.os.Parcel;
import android.os.Parcelable;

import com.payu.india.Model.PaymentDetails;

public class QuickPaySavedOption extends PaymentDetails implements Parcelable {

    private String pgTitle;
    private String pgDetails;
    private String ibiboCode;
    private String paymentType;
    private String userCredential;
    private boolean pgDisplay;
    private boolean pgUP;
    private boolean tokenTxn;
    private String phoneNumber;

    public String getPgTitle() {
        return pgTitle;
    }

    public void setPgTitle(String pgTitle) {
        this.pgTitle = pgTitle;
    }

    public String getPgDetails() {
        return pgDetails;
    }

    public void setPgDetails(String pgDetails) {
        this.pgDetails = pgDetails;
    }

    public String getIbiboCode() {
        return ibiboCode;
    }

    public void setIbiboCode(String ibiboCode) {
        this.ibiboCode = ibiboCode;
    }

    public boolean isPgDisplay() {
        return pgDisplay;
    }

    public void setPgDisplay(boolean pgDisplay) {
        this.pgDisplay = pgDisplay;
    }

    public boolean isPgUP() {
        return pgUP;
    }

    public void setPgUP(boolean pgUP) {
        this.pgUP = pgUP;
    }

    public String getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public String getUserCredential() {
        return userCredential;
    }

    public void setUserCredential(String userCredential) {
        this.userCredential = userCredential;
    }

    public boolean isTokenTxn() {
        return tokenTxn;
    }

    public void setTokenTxn(boolean tokenTxn) {
        this.tokenTxn = tokenTxn;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public QuickPaySavedOption() {

    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(pgTitle);
        parcel.writeString(pgDetails);
        parcel.writeString(ibiboCode);
        parcel.writeString(paymentType);
        parcel.writeString(userCredential);
        parcel.writeByte((byte) (pgDisplay ? 1 : 0));
        parcel.writeByte((byte) (pgUP ? 1 : 0));
        parcel.writeByte((byte) (tokenTxn ? 1 : 0));
        parcel.writeString(phoneNumber);
    }

    public static final Parcelable.Creator<QuickPaySavedOption> CREATOR
            = new Parcelable.Creator<QuickPaySavedOption>() {
        public QuickPaySavedOption createFromParcel(Parcel in) {
            return new QuickPaySavedOption(in);
        }

        public QuickPaySavedOption[] newArray(int size) {
            return new QuickPaySavedOption[size];
        }
    };

    QuickPaySavedOption(Parcel in) {
        pgTitle = in.readString();
        pgDetails = in.readString();
        ibiboCode = in.readString();
        paymentType = in.readString();
        userCredential = in.readString();
        pgDisplay = in.readByte() != 0;
        pgUP = in.readByte() != 0;
        tokenTxn = in.readByte() != 0;
        phoneNumber = in.readString();
    }
}
