package com.payu.india.Model.QuickPay;

import android.util.Log;

import com.payu.paymentparamhelper.PayuConstants;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Purpose of the class to perform construction of the Request Params for the Quick Pay thourgh
 * recommendation engine
 */
public class QuickPayRequest extends V2ApiBase {

    /* Amount  */
    private final double amount;

    /* User Token */
    private final String userToken;

    /* Phone  */
    private final String phone;

    /* Email  */
    private final String email;

    /* Request Id  */
    private final String requestId;

    /* Request Type  */
    private final String requestType;
    /* deviceId  */
    private final String deviceId;
    /* userCredential  */
    private final String userCredential;

    private QuickPayRequest(Builder builder) {
        this.amount = builder.amount;
        this.userToken = builder.userToken;
        this.phone = builder.phone;
        this.email = builder.email;
        this.requestId = builder.requestId;
        this.requestType = builder.requestType;
        this.deviceId = builder.deviceId;
        this.userCredential = builder.userCredential;
    }

    @Override
    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PayuConstants.AMOUNT, amount);
            jsonObject.put(PayuConstants.USER_TOKEN, userToken);
            jsonObject.put(PayuConstants.PHONE, phone);
            jsonObject.put(PayuConstants.EMAIL, email);
            jsonObject.put(PayuConstants.PAYU_REQUESTID, requestId);
            jsonObject.put(PayuConstants.GV_REQUESTTYPE, requestType);
            jsonObject.put(PayuConstants.PAYU_DEVICE_ID, deviceId);
            jsonObject.put(PayuConstants.GV_USER_CRED, userCredential);
        } catch (JSONException e) {
            Log.d("QuickPayRequest", "Exception " + e.getMessage());
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private double amount;
        private String userToken;
        private String phone;
        private String email;
        private String requestId;
        private String requestType;
        private String deviceId;
        private String userCredential;

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder setRequestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder setPhone(String phone) {
            this.phone = phone;
            return this;
        }

        public Builder setAmount(double amount) {
            this.amount = amount;
            return this;
        }

        public Builder setUserToken(String userToken) {
            this.userToken = userToken;
            return this;
        }

        public Builder setDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder setUserCredential(String userCredential) {
            this.userCredential = userCredential;
            return this;
        }

        public QuickPayRequest build() {
            return new QuickPayRequest(this);
        }
    }
}
